<?php

/**
 * Enqueue CSS & JS
 */
function kadence_admin_scripts($hook) {
	if( $hook == 'toplevel_page_kad_options' || $hook == 'widgets.php' ) {
		wp_enqueue_script('select2', get_template_directory_uri() . '/assets/js/min/select2-min.js', array( 'jquery' ), VIRTUE_VERSION, false);
		wp_dequeue_script('select2-js' ); 
	}
	if( $hook != 'edit.php' && $hook != 'post.php' && $hook != 'post-new.php' && $hook != 'widgets.php' && $hook != 'toplevel_page_kad_options' && $hook != 'term.php') {
		return;
  	}
  	wp_enqueue_style('kad_adminstyles', get_template_directory_uri() . '/assets/css/kad_adminstyles.css', false, VIRTUE_VERSION);
	if (class_exists('woocommerce')) {
		if ( version_compare( WC_VERSION, '2.7', '>' ) ) {  
			wp_register_script('select2', get_template_directory_uri() . '/assets/js/min/select2_v4-min.js', false, VIRTUE_VERSION, false);
		} else {
			wp_register_script('select2', get_template_directory_uri() . '/assets/js/min/select2-min.js', false, VIRTUE_VERSION, false);
			
		}
	} else {
		wp_register_script('select2', get_template_directory_uri() . '/assets/js/min/select2_v4-min.js', false, VIRTUE_VERSION, false);
	}
	wp_enqueue_script('select2');
	wp_dequeue_script('select2-js'); 

    wp_register_script('mustache-js', get_template_directory_uri() . '/assets/js/vendor/mustache.min.js');
  	wp_enqueue_script('kad_adminscripts', get_template_directory_uri() . '/assets/js/min/kad_adminscripts-min.js', array( 'wp-color-picker', 'jquery', 'underscore', 'backbone', 'jquery-ui-sortable', 'mustache-js'), VIRTUE_VERSION, false);

}

add_action('admin_enqueue_scripts', 'kadence_admin_scripts');

function kadence_gallery_default_type_set_link( $settings ) {
    $settings['galleryDefaults']['link'] = 'file';
    return $settings;
}
add_filter( 'media_view_settings', 'kadence_gallery_default_type_set_link');
add_action( 'print_media_templates', 'kadence_media_gallery_extras');

function kadence_media_gallery_extras(){
?>
<script type="text/html" id="tmpl-custom-gallery-setting">
    <hr style="clear: both;">
    <h3 style="margin-top:10px;"><?php esc_html_e( 'KT Extra Gallery Settings', 'virtue' );?></h3>
    <label class="setting">
      <span><?php _e('Type', 'virtue'); ?></span>
      <select data-setting="type">
        <option value="default"><?php esc_html_e('Default', 'virtue');?></option>
        <option value="slider"><?php esc_html_e('Slider', 'virtue');?></option>
        <option value="carousel"><?php esc_html_e('Carousel', 'virtue');?></option>
        <option value="mosaic"><?php esc_html_e('Mosaic', 'virtue');?></option>
        <option value="grid"><?php esc_html_e('Custom Grid', 'virtue');?></option>
        <option value="imagecarousel"><?php esc_html_e('Image Carousel', 'virtue');?></option>
      </select>
    </label>
    <label class="setting">
      <span><?php esc_html_e('Show Captions', 'virtue'); ?></span>
      <select data-setting="caption">
      <option value="default"><?php esc_html_e('Default', 'virtue');?></option>
        <option value="false"><?php esc_html_e('False', 'virtue');?></option>
        <option value="true"><?php esc_html_e('True', 'virtue');?></option>
      </select>
    </label>
    <label class="setting">
      <span><?php esc_html_e('Masonry', 'virtue'); ?></span>
      <select data-setting="masonry">
        <option value="default"><?php esc_html_e('Default', 'virtue');?></option>
        <option value="false"><?php esc_html_e('False', 'virtue');?></option>
        <option value="true"><?php esc_html_e('True', 'virtue');?></option>
      </select>
    </label>
    <h4><?php esc_html_e('Slider Option - Settings', 'virtue');?></h4>
    <label class="setting">
        <span style="min-width: 50px;"><?php esc_html_e('Width', 'virtue'); ?></span>
        <input type="text" value="" data-setting="width" style="float:left;">
    </label>
    <label class="setting">
        <span style="min-width: 50px;"><?php esc_html_e('Height', 'virtue'); ?></span>
        <input type="text" value="" data-setting="height" style="float:left;">
    </label>
    <hr style="clear: both;">
</script>

<script> 
    jQuery( window ).load(function () {
            if ( typeof wp === 'undefined' || ! wp.media || ! wp.media.gallery ) {
                    return;
            }
            jQuery.extend(wp.media.gallery.defaults, {
                type: 'default',
                caption: 'default',
                masonry: 'default',
                width: '',
                height: '',
            }); 

            wp.media.view.Settings.Gallery = wp.media.view.Settings.Gallery.extend({
            template: function(view){
              return wp.media.template('gallery-settings')(view) + wp.media.template('custom-gallery-setting')(view);
            }
            });
    });

</script>
<?php

}