<?php
/**
 * Main plugin class
 */
class Kadence_Blocks_Pro {
	/**
	 * Instance Control
	 *
	 * @var null
	 */
	private static $instance = null;

	/**
	 * Instance Control
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	public function __construct() {
		add_action( 'plugins_loaded', array( $this, 'on_plugins_loaded' ) );
	}
	public function on_plugins_loaded() {
		require_once KT_BP_PATH . 'dist/class-kadence-blocks-post-select-controller.php';
		require_once KT_BP_PATH . 'dist/init.php';
		require_once KT_BP_PATH . 'dist/dynamicblocks/post-grid-carousel.php';
		if ( class_exists( 'Woocommerce' ) ) {
			require_once KT_BP_PATH . 'dist/dynamicblocks/product-carousel.php';
		}
		require_once KT_BP_PATH . 'dist/class-kadence-blocks-pro-frontend.php';
		require_once KT_BP_PATH . 'dist/class-kadence-blocks-pro-backend.php';
		/**
		 * Plugin check class.
		 */
		require_once KT_BP_PATH . 'class-kadence-blocks-pro-plugin-check.php';
		if ( ! Kadence_Blocks_Pro_Plugin_Check::active_check_kadence_blocks() ) {
			add_action( 'admin_notices', array( $this, 'admin_notice_need_kadence_blocks' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
		}
	}
	public function admin_notice_need_kadence_blocks() {
		if ( get_transient( 'kadence_blocks_pro_free_plugin_notice' ) || ! current_user_can( 'manage_options' ) ) {
			return;
		}
		$installed_plugins = get_plugins();
		if ( ! isset( $installed_plugins['kadence-blocks/kadence-blocks.php'] ) ) {
			$button_label = esc_html__( 'Install Kadence Blocks', 'kadence-blocks-pro' );
			$data_action  = 'install';
		} else {
			$button_label = esc_html__( 'Activate Kadence Blocks', 'kadence-blocks-pro' );
			$data_action  = 'activate';
		}
		$install_link    = wp_nonce_url(
			add_query_arg(
				array(
					'action' => 'install-plugin',
					'plugin' => 'kadence-blocks',
				),
				network_admin_url( 'update.php' )
			),
			'install-plugin_kadence-blocks'
		);
		$activate_nonce  = wp_create_nonce( 'activate-plugin_kadence-blocks/kadence-blocks.php' );
		$activation_link = self_admin_url( 'plugins.php?_wpnonce=' . $activate_nonce . '&action=activate&plugin=kadence-blocks%2Fkadence-blocks.php' );
		echo '<div class="notice notice-error is-dismissible kt-blocks-pro-notice-wrapper">';
		echo '<p>'.sprintf( __( 'Kadence Bocks Pro requires %s to be active for all functions to work.', 'kadence-blocks-pro' ).'</p>', '<a target="_blank" href="https://wordpress.org/plugins/kadence-blocks/">Kadence Blocks</a>');
		echo '<p class="submit">';
		echo '<a class="button button-primary kt-install-blocks-btn" data-redirect-url="' . esc_url( admin_url( 'options-general.php?page=kadence_blocks' ) ) . '" data-activating-label="' . esc_attr__( 'Activating...', 'kadence-blocks-pro' ) . '" data-activated-label="' . esc_attr__( 'Activated', 'kadence-blocks-pro' ) . '" data-installing-label="' . esc_attr__( 'Installing...', 'kadence-blocks-pro' ) . '" data-installed-label="' . esc_attr__( 'Installed', 'kadence-blocks-pro' ) . '" data-action="' . esc_attr( $data_action ) . '" data-install-url="' . esc_attr( $install_link ) . '" data-activate-url="' . esc_attr( $activation_link ) . '">' . esc_html( $button_label ) . '</a>';
		echo '</p>';
		echo '</div>';
		wp_enqueue_script( 'kt-blocks-install' );
	}
	public function admin_scripts( $hook ) {
		wp_register_script( 'kt-blocks-install', KT_BP_URL . 'dist/settings/admin-activate.js', false, KT_BP_VERSION );
		wp_enqueue_style( 'kt-blocks-install', KT_BP_URL . 'dist/settings/admin-activate.css', false, KT_BP_VERSION );	
	}
}
Kadence_Blocks_Pro::get_instance();
