<?php
/**
 * Enqueue admin CSS/JS and edit width functions
 *
 * @since   1.0.0
 * @package Kadence Blocks Pro
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Enqueue Gutenberg block assets for backend editor.
 *
 * `wp-blocks`: includes block type registration and related functions.
 * `wp-element`: includes the WordPress Element abstraction for describing the structure of your blocks.
 * `wp-i18n`: To internationalize the block's text.
 *
 * @since 1.0.0
 */
function kadence_blocks_pro_editor_assets() {
	// Scripts.
	wp_enqueue_script( 'kadence-blocks-pro-js', KT_BP_URL . 'dist/blocks.build.js', array( 'wp-api-fetch', 'wp-blocks', 'wp-i18n', 'wp-element' ), KT_BP_VERSION, true );
	wp_localize_script( 'kadence-blocks-pro-js', 'ktGbToolsData', array(
		'restBase' => esc_url_raw( get_rest_url() ),
		'postSelectEndpoint' => '/rbmh/v1/post-select',
		'postTypes' => kadence_blocks_pro_get_post_types(),
		'taxonomies' => kadence_blocks_pro_get_taxonomies(),
		'wcIsActive' => class_exists( 'Woocommerce' ),
		'wcProductCarouselPlaceholder' => ( function_exists( 'wc_placeholder_img_src' ) ? wc_placeholder_img_src() : '' ),
	) );

	// Styles.
	wp_enqueue_style( 'kadence-blocks-pro-editor-css', KT_BP_URL . 'dist/blocks.editor.build.css', array( 'wp-edit-blocks' ), KT_BP_VERSION );
}
add_action( 'enqueue_block_editor_assets', 'kadence_blocks_pro_editor_assets' );
add_action( 'rest_api_init', 'kadence_blocks_pro_register_api_endpoints' );
/**
 * Setup the post select API endpoint.
 *
 * @return void
 */
function kadence_blocks_pro_register_api_endpoints() {
	$controller = new Kadence_Blocks_Post_Select_Controller;
	$controller->register_routes();
}
function kadence_blocks_pro_get_post_types() {
	$args = array(
		'public'       => true,
		'show_in_rest' => true,
	);
	$post_types = get_post_types( $args, 'objects' );
	$output = array();
	foreach ( $post_types as $post_type ) {
		if ( 'product' == $post_type->name || 'attachment' == $post_type->name ) {
			continue;
		}
		$output[] = array(
			'value' => $post_type->name,
			'label' => $post_type->label,
		);
	}
	return apply_filters( 'kadence_blocks_post_types', $output );
}
function kadence_blocks_pro_get_taxonomies() {
	$post_types = kadence_blocks_pro_get_post_types();
	$output = array();
	foreach ( $post_types as $key => $post_type ) {
		$taxonomies = get_object_taxonomies( $post_type['value'], 'objects' );
		$taxs = array();
		foreach ( $taxonomies as $term_slug => $term ) {
			if ( ! $term->public || ! $term->show_ui ) {
				continue;
			}
			$taxs[ $term_slug ] = $term;
			$terms = get_terms( $term_slug );
			$term_items = array();
			if ( ! empty( $terms ) ) {
				foreach ( $terms as $term_key => $term_item ) {
					$term_items[] = array(
						'value' => $term_item->term_id,
						'label' => $term_item->name,
					);
				}
				$output[ $post_type['value'] ]['terms'][ $term_slug ] = $term_items;
			}
		}
		$output[ $post_type['value'] ]['taxonomy'] = $taxs;
	}
	return apply_filters( 'kadence_blocks_taxonomies', $output );
}