/**
 * Video Pop
 */
jQuery( document ).ready( function( $ ) {
	$( '.kadence-video-popup-link.kadence-video-type-external' ).magnificPopup( {
		type: 'iframe',
		mainClass: 'mfp-kt-blocks',
	} );
	$( '.kadence-video-popup-link.kadence-video-type-local' ).each( function() {
		var id = $( this ).attr( 'data-popup-id' );
		var auto = $( this ).attr( 'data-popup-auto' );
		$( this ).magnificPopup( {
			mainClass: 'mfp-kt-blocks',
			items: {
				src: '#' + id,
				type: 'inline',
			},
			callbacks: {
				open: function() {
					// Play video on open:
					if ( 'true' == auto ) {
						$( this.content ).find( 'video' )[ 0 ].play();
					}
				},
				close: function() {
					// Pause video on close:
					$( this.content ).find( 'video' )[ 0 ].pause();
				},
			},
		} );
	} );
} );
