<?php
/**
 * Plugin Name: Kadence Blocks Pro
 * Plugin URI:  https://www.kadencethemes.com/product/kadence-gutenberg-blocks/
 * Description: Extends Kadence Blocks with powerful extras that make it possible to create beautiful content in the WordPress Block Editor
 * Version:     1.2.0
 * Author:      Kadence Themes
 * Author URI:  https://www.kadencethemes.com/
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Domain Path: /languages
 * Text Domain: kadence-blocks-pro
 *
 * @package Kadence Blocks Pro
 */

/**
 * Main const
 */
define( 'KT_BP_PATH', realpath( plugin_dir_path( __FILE__ ) ) . DIRECTORY_SEPARATOR );
define( 'KT_BP_URL', plugin_dir_url( __FILE__ ) );
define( 'KT_BP_VERSION', '1.2.0' );

/**
 * Main class
 */
require_once KT_BP_PATH . 'class-kadence-blocks-pro.php';

/**
 * Plugin Updates
 */
function kadence_blocks_pro_updating() {
	// Load updater class.
	require_once 'wp-updates-plugin.php';
	require_once KT_BP_PATH . 'kadence-classes/kadence-activation/updater.php';
}
add_action( 'after_setup_theme', 'kadence_blocks_pro_updating', 1 );
