<?php 
/*
Plugin Name: Kadence Custom Fonts
Description: A simple plugin to add custom fonts for Kadence Themes
Version: 1.0.1
Author: Kadence Themes
Author URI: http://kadencethemes.com/
License: GPLv2 or later
Text Domain: kadence-custom-fonts
*/

class Kadence_Custom_Fonts {

	public static $font_query = null;

	public function __construct() {
		add_action('plugins_loaded', array( $this, 'on_plugins_loaded' ) );
		add_action('plugins_loaded', array( $this, 'load_textdomain' ) );
	}
	function load_textdomain() {
		load_plugin_textdomain( 'kadence-custom-fonts', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' ); 
	}
	public function on_plugins_loaded() {

		define( 'KT_CUSTOM_FONTS_PATH' , realpath( plugin_dir_path(__FILE__) ) . DIRECTORY_SEPARATOR );
		define( 'KT_CUSTOM_FONTS_URL' , plugin_dir_url(__FILE__) );
		define( 'KT_CUSTOM_FONTS_VERSION' , '1.0.1' );

		// Admin Options
		require_once( KT_CUSTOM_FONTS_PATH . 'includes/cmb/init.php');
		require_once( KT_CUSTOM_FONTS_PATH . 'includes/metaboxes.php');
		require_once( KT_CUSTOM_FONTS_PATH . 'includes/font_post.php');

		add_action( 'init', array( $this, 'on_init' ) );

	}
	public function on_init() {
		//Add our fonts mime types
		add_filter( 'upload_mimes', array( $this, 'extra_mime_types' ) );

		add_filter( 'cmb2_{_kad_font_svg}_is_valid_img_ext', array( $this, 'no_preview_image' ) );

		add_filter( 'redux/ascend/field/typography/custom_fonts', array( $this, 'send_fonts_redux_list') );

		add_filter( 'redux/kadence_slider/field/typography/custom_fonts', array( $this, 'send_fonts_redux_list') );

		add_filter( 'redux/kadence_pricing_table/field/typography/custom_fonts', array( $this, 'send_fonts_redux_list') );

		add_filter( 'redux/virtue_premium/field/typography/custom_fonts', array( $this, 'send_fonts_redux_list') );

		add_filter( 'redux/virtue/field/typography/custom_fonts', array( $this, 'send_fonts_redux_list') );

		add_filter( 'redux/pinnacle/field/typography/custom_fonts', array( $this, 'send_fonts_redux_list') );

		add_action( 'admin_enqueue_scripts',  array( $this, 'add_weight_style_fonts' ), 100);

		add_action( 'admin_head', array( $this, 'custom_font_css'), 10 );

		add_action( 'wp_head', array( $this, 'custom_font_css' ), 10 );

	}
	function add_weight_style_fonts( ) {

		wp_enqueue_script( 'kadence_custom_fonts_admin_scripts', KT_CUSTOM_FONTS_URL . 'assets/js/custom_fonts_admin.js', array( 'jquery' ), KT_CUSTOM_FONTS_VERSION, true );
		$font_array = $this->build_font_array();
		wp_localize_script( 'kadence_custom_fonts_admin_scripts', 'KCFO', $font_array );
	}
	public static function kt_font_query() {
		if ( is_null( self::$font_query ) ) {
			$fonts = new WP_Query( array(
				'post_type'			=> 'kt_font',
				'post_status'		=> 'published',
				'posts_per_page'	=> -1,
			));

			self::$font_query = $fonts->posts;
		}
		return self::$font_query;
	}
	public function build_font_array() {
		$font_array = array( 'font_familes' => array() );
		$fonts = $this->kt_font_query();
		if ( $fonts ) {
			foreach ($fonts as $font ) {
				$name = get_post_meta( $font->ID, '_kad_font_name', true );
				$weight = get_post_meta( $font->ID, '_kad_font_weight', true );
				$style = get_post_meta( $font->ID, '_kad_font_style', true );
				if( ! empty( $style ) && $style != 'normal' ){
					$style_setting = $weight.$style;
				} else {
					$style_setting = $weight;
				}
				if ( ! empty( $name ) ) {
					if( isset( $font_array['font_familes'][$name] ) ) {
						$font_array['font_familes'][$name]['styles'][$style_setting] = $style_setting;
					} else {
						$font_array['font_familes'][$name] = array(
							'name' => $name,
							'styles' => array(
								$style_setting => $style_setting,
							),
						);
					}
				}
			}
		}
		return $font_array;
	}
	public function custom_font_css() {

		$css = '<style type="text/css">';

		$fonts = $this->kt_font_query();
		if ( $fonts ) {
			foreach ( $fonts as $font ) {
				$name 	= get_post_meta( $font->ID, '_kad_font_name', true );
				if ( ! empty( $name ) ) {
					$style_name 	= get_post_meta( $font->ID, '_kad_font_style_name', true );
					$weight 	= get_post_meta( $font->ID, '_kad_font_weight', true );
					$style 		= get_post_meta( $font->ID, '_kad_font_style', true );
					$eot 		= get_post_meta( $font->ID, '_kad_font_eot', true );
					$woff2 		= get_post_meta( $font->ID, '_kad_font_woff2', true );
					$woff 		= get_post_meta( $font->ID, '_kad_font_woff', true );
					$ttf 		= get_post_meta( $font->ID, '_kad_font_ttf', true );
					$svg 		= get_post_meta( $font->ID, '_kad_font_svg', true );
					$css .= '@font-face {';
					$css .= 'font-family: "'.$name.'";';
					if ( ! empty( $style ) ) {
						$css .= 'font-style: '.$style.';';
					}
					if ( ! empty( $weight ) ) {
						$css .= 'font-weight: '.$weight.';';
					}
					if ( ! empty( $eot ) ) {
						$css .= 'src: url("'.$eot.'");';
					}
					$css .= 'src:';
					if(! empty( $style_name ) ) {
						$css .= 'local("'.$style_name.'"),';
					}
					if ( ! empty( $eot ) ) {
						$css .= 'url("'.$eot.'?#iefix") format("embedded-opentype")';
					} else if( ! empty( $ttf ) ) {
						$css .= 'url("'.$ttf.'") format("truetype")';
					} else if( ! empty( $woff ) ) {
						$css .= 'url("'.$woff.'") format("woff")';
					}
					if ( ! empty( $woff2 ) ) {
						$css .= ',url("'.$woff2.'") format("woff2")';
					}
					if ( ! empty( $woff ) ) {
						$css .= ',url("'.$woff.'") format("woff")';
					}
					if ( ! empty( $ttf ) ) {
						$css .= ',url("'.$ttf.'") format("truetype")';
					}
					if ( ! empty( $svg ) ) {
						$css .= ',url("'.$svg.'") format("svg");';
					} else {
						$css .= ';';
					}
					$css .= '}';
				}
			}
		}
		$css .= '</style>';

		echo $css;
	}

	function send_fonts_redux_list( $custom_fonts ) {

		$fonts_custom = array('Custom Fonts' => array());

		$fonts = $this->kt_font_query();
		if ( $fonts ) {
			foreach ( $fonts as $font ) {
				$name = get_post_meta( $font->ID, '_kad_font_name', true );
				if ( ! empty( $name ) ) {
					$fonts_custom['Custom Fonts'][$name] = $name;
				}
			}
		} else {
			return $custom_fonts;
		}
		return $fonts_custom;
	}

	public function no_preview_image() {
		return false;
	}
	/**
	 * Add mime types specific to font files
	 *
	 * @param array $mimes
	 *
	 * @return array
	 */
	function extra_mime_types( $mimes ) {
		$mimes['eot'] = 'application/vnd.ms-fontobject';
		$mimes['otf|ttf'] = 'application/font-sfnt';
		$mimes['ttf'] = 'application/x-font-ttf';
		$mimes['otf|ttf'] = 'font/opentype';
		$mimes['woff'] = 'application/font-woff';
		$mimes['woff2'] = 'application/font-woff2';
		$mimes['woff2'] = 'font/woff2';

		$mimes['svg'] = 'image/svg+xml';

		return $mimes;
	}
	
}
 
new Kadence_Custom_Fonts();

require_once('wp-updates-plugin.php');

$kadence_custom_fonts = new PluginUpdateChecker_2_0 ('https://kernl.us/api/v1/updates/5af519082deb0942d04555ef/',__FILE__, 'kadence-custom-fonts', 1); 