<?php 
add_action( 'plugins_loaded', 'kadence_pt_plugin_loaded' );

function kadence_pt_plugin_loaded() {
	class KadencePTAdmin {
	
		// Creates the menu and the admin panel
		public function __construct() {
			if(is_admin()) {
			  	if(KADENCE_PT_DEBUG || KADENCE_PT_VERSION != get_option('kpt_version')) {
			      	KadencePTDatabase::setDatabase();
			  	}
			  	if(KADENCE_PT_VERSION != get_option('kpt_version')) {
			      	KadencePTDatabase::setVersion();
			  	}

			  	KadencePTAdmin::init_admin();
			  	KadencePTAdmin::hook_admin_scripts();

			  	require_once (KADENCE_PT_PATH . '/admin/ajax_functions.php');
			}
		}
		public static function ktp_template_options() {
			$templates = array(
				array(
					'file'=>'example_01',
					'image'=>KADENCE_PT_URL .'admin/templates/example_01.jpg',
					'title'=>'Example 01',
					),
				array(
					'file'=>'example_02',
					'image'=>KADENCE_PT_URL .'admin/templates/example_02.jpg',
					'title'=>'Example 02',
					),
				array(
					'file'=>'example_03',
					'image'=>KADENCE_PT_URL .'admin/templates/example_03.jpg',
					'title'=>'Example 03',
					),
				array(
					'file'=>'example_04',
					'image'=>KADENCE_PT_URL .'admin/templates/example_04.jpg',
					'title'=>'Example 04',
					),
				array(
					'file'=>'example_05',
					'image'=>KADENCE_PT_URL .'admin/templates/example_05.jpg',
					'title'=>'Example 05',
					),
				array(
					'file'=>'example_06',
					'image'=>KADENCE_PT_URL .'admin/templates/example_06.jpg',
					'title'=>'Example 06',
					),
				);
			return $templates;
		}
		public static function init_admin() {
			add_action('admin_menu', 'KadencePTAdmin::add_menu_item');
		}
		
		public static function add_menu_item() {
			global $kpt_manage_page;
			$kpt_manage_page = add_menu_page('KT Price Table', 'Pricing Tables', 'edit_pages', 'kadencepricingtable', 'KadencePTAdmin::display_page', 'dashicons-chart-bar');
		}
		
		// Go to the correct page
		public static function display_page() {
			if(!isset($_GET['view'])) {
				$index = 'base';
			} else {
				$index = $_GET['view'];
			}
			
			
			
			?>
			<div class="wrap" style="height:0;overflow:hidden;"><h2></h2></div>
			
			<div class="wrap ksp-admin-page ksp-admin kpt-admin">	
			<div id="kt_ajax_overlay">
				<div class="ajaxnotice-kt"><span class="kt-notice-saving"><?php echo __( 'Saving', 'kadence-importer' ); ?></span>
				<div class="bubblingG">
				    <span id="bubblingG_1">
				    </span>
				    <span id="bubblingG_2">
				    </span>
				    <span id="bubblingG_3">
				    </span>
				</div>
				</div>
				</div>
					<div class="ksp-logo">
						<img src="<?php echo esc_url(KADENCE_PT_URL .'admin/images/kpricingtable.png');?>" width="300" height="91">
						<?php if('base' != $index) { ?>
							<a class="ksp_back_overview" href="<?php echo esc_url(admin_url('?page=kadencepricingtable'));?>"><?php _e('Back to tables overview', 'kadence-pricing-table'); ?></a>
						<?php } ?>
					</div>

				<noscript class="ksp-no-js">
					<?php _e('JavaScript must be enabled to view this page correctly.', 'kadence-pricing-table'); ?>
				</noscript>
				
				<div class="ksp-message ksp-message-ok" style="display: none;"><?php _e('Operation completed successfully.', 'kadence-pricing-table'); ?></div>
				<div class="ksp-message ksp-message-error" style="display: none;"><?php _e('Something went wrong.', 'kadence-pricing-table'); ?></div>
				
				<?php
				
				switch($index) {
					case 'base':
						self::display_base();
					break;
					case 'import':
						self::display_import();
					break;
					case 'tableadd':
					case 'tableedit':
						self::display_table();
					break;
				}
				
				?>
			
			</div>
			<?php
		}
		
		// Display the table list base page
		public static function display_base() {		
			?>
			<div class="ksp-base">
				<?php require_once KADENCE_PT_PATH . 'admin/base.php'; ?>
			</div>
			<?php
		}

		// Display the table import page
		public static function display_import() {		
			?>
			<div class="ksp-base">
				<?php require_once KADENCE_PT_PATH . 'admin/import.php'; ?>
			</div>
			<?php
		}
		

		// Displays the slider page in wich you can add or modify sliders, slides and elements
		public static function display_table() {
			global $wpdb;
			
			// Check what the user is doing: is it adding or modifying a slider? 
			if($_GET['view'] == 'tableadd') {
				$edit = false;
				$id = NULL;	//This variable will be used in other files. It contains the ID of the SLIDER that the user is editing
			} else {
				$edit = true;
				$id = isset($_GET['id']) ? $_GET['id'] : NULL;
				$table = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'kpt_tables WHERE id = ' . $id);
				$panes = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'kpt_panes WHERE table_parent = ' . $id . ' ORDER BY position');
				// The elements variable are updated in the foreachh() loop directly in the "slides.php" file
			}
			?>
			
			<div class="ksp-slider kpt-table <?php echo $edit ? 'kpt-edit-table' : 'kpt-add-table' ?>">
					
					<?php require_once KADENCE_PT_PATH . 'admin/table.php'; ?>
					<?php 
					if($edit) {
						require_once KADENCE_PT_PATH . 'admin/tablerows.php';
						require_once KADENCE_PT_PATH . 'admin/panes.php';
					}
					?>
				
				<br />
				
				<a class="ksp-button ksp-is-primary ksp-save-settings" data-id="<?php echo esc_attr($id); ?>" href="#"><?php _e('Save Settings', 'kadence-pricing-table'); ?></a>
				
			</div>

			<?php
		}
		

		// Include CSS and JavaScript
		public static function enqueues($hook) {
			global $kpt_manage_page;
			if( $hook != $kpt_manage_page ) 
	    	return;
			wp_enqueue_style('kadence-pricing-table-admin', KADENCE_PT_URL . 'admin/css/kpt-admin.css', false, KADENCE_PT_VERSION);
			wp_enqueue_script('jquery-ui-sortable');
			wp_enqueue_style('wp-color-picker');
			wp_enqueue_media();
			wp_enqueue_script('kadence-pricing-table-admin', KADENCE_PT_URL . 'admin/js/kpt-admin.js', array('wp-color-picker', 'jquery'), KADENCE_PT_VERSION, true);
			self::kpt_localization();
			
		}
		public static function enqueue_icon() {
			wp_enqueue_style('kadence-pricing-table-icon-admin', KADENCE_PT_URL . 'admin/css/k-pricing-table-admin.css', false, KADENCE_PT_VERSION);
		}
		public static function admin_google_fonts() {
			global $kpt_manage_page;
			$data = get_option('kadence_pricing_table');
	    	$screen = get_current_screen();
	    	
			if (!isset($screen) || $screen->id != $kpt_manage_page ) {
				return;
			}
			$fonts = kpt_font_list();
			$gfonts = '';
			foreach ($fonts as $font) {
				if($font['info']['data-google'] == 'true'){
					$gfonts .= '"'.esc_js($font['info']['name']).':'.esc_js($font['info']['data-weight']).'",';
				}
			}
			echo '<script src="https://ajax.googleapis.com/ajax/libs/webfont/1.6.16/webfont.js"></script>
					<script>
					  WebFont.load({
					    google: {
					      families: ['.$gfonts.']
					    }
					  });
					</script>';

			echo '<style type="text/css" id="ksp-admin-css">.ksp-slide-editing-area .ksp-layer {';
			if(isset($data['font_option_one']['font-family'])) { echo 'font-family:'. $data["font_option_one"]["font-family"].';';}
			if(isset($data['font_option_one']['font-weight'])) { echo 'font-weight:'. $data["font_option_one"]["font-weight"].';';}
			if(isset($data['font_option_one']['font-style'])) { echo 'font-style:'. $data["font_option_one"]["font-style"].';';}
			echo '}'; 
			echo '</style>';
			
		}
		public static function hook_admin_scripts() {
			add_action('admin_enqueue_scripts', 'KadencePTAdmin::enqueues' );
			add_action('admin_enqueue_scripts', 'KadencePTAdmin::enqueue_icon' );
			add_action('admin_head', 'KadencePTAdmin::admin_google_fonts' );
		}

		public static function kpt_localization() {
			// Here the translations for the admin.js file
			$kadence_pricing_table_translations = array(
				'table' => __('Table', 'kadence-pricing-table'),
				'pane_delete_confirm' => __('The column will be deleted. Are you sure?', 'kadence-pricing-table'),
				'pane_delete_just_one' => __('You can\'t delete this. You must have at least one column.', 'kadence-pricing-table'),
				'row_delete_confirm' => __('The row will be deleted. Are you sure?', 'kadence-pricing-table'),
				'row_delete_just_one' => __('You can\'t delete this. You must have at least one row.', 'kadence-pricing-table'),
				'table_delete_confirm' => __('The table will be deleted. Are you sure?', 'kadence-pricing-table'),
				'kpt_admin' => esc_url(admin_url('?page=kadencepricingtable')),
			);
			wp_localize_script('kadence-pricing-table-admin', 'kpt_translations', $kadence_pricing_table_translations);
		}
	}
	$GLOBALS['kadenceptadmin'] = new KadencePTAdmin();
}

?>