<?php

	/**
	 *  A method for inserting multiple rows into the specified table
	 *  Updated to include the ability to Update existing rows by primary key
	 *  
	 *  Usage Example for insert: 
	 *
	 *  $insert_arrays = array();
	 *  foreach($assets as $asset) {
	 *  $time = current_time( 'mysql' );
	 *  $insert_arrays[] = array(
	 *  'type' => "multiple_row_insert",
	 *  'status' => 1,
	 *  'name'=>$asset,
	 *  'added_date' => $time,
	 *  'last_update' => $time);
	 *
	 *  }
	 *
	 *
	 *  wp_insert_rows($insert_arrays, $wpdb->tablename);
	 *
	 *  Usage Example for update:
	 *
	 *  wp_insert_rows($insert_arrays, $wpdb->tablename, true, "primary_column");
	 *
	 *
	 * @param array $row_arrays
	 * @param string $wp_table_name
	 * @param boolean $update
	 * @param string $primary_key
	 * @return false|int
	 *
	 * @author	Ugur Mirza ZEYREK
	 * @contributor Travis Grenell
	 * @source http://stackoverflow.com/a/12374838/1194797
	 */

function kpt_insert_rows($row_arrays = array(), $wp_table_name, $update = false, $primary_key = null) {
	global $wpdb;
	$wp_table_name = esc_sql($wp_table_name);
	// Setup arrays for Actual Values, and Placeholders
	$values        = array();
	$place_holders = array();
	$query         = "";
	$query_columns = "";
	
	$query .= "INSERT INTO `{$wp_table_name}` (";
	foreach ($row_arrays as $count => $row_array) {
		foreach ($row_array as $key => $value) {
			if ($count == 0) {
				if ($query_columns) {
					$query_columns .= ", " . $key . "";
				} else {
					$query_columns .= "" . $key . "";
				}
			}
			
			$values[] = $value;
			
			$symbol = "%s";
			if (is_numeric($value)) {
				if (is_float($value)) {
					$symbol = "%f";
				} else {
					$symbol = "%d";
				}
			}
			if (isset($place_holders[$count])) {
				$place_holders[$count] .= ", '$symbol'";
			} else {
				$place_holders[$count] = "( '$symbol'";
			}
		}
		// mind closing the GAP
		$place_holders[$count] .= ")";
	}
	
	$query .= " $query_columns ) VALUES ";
	
	$query .= implode(', ', $place_holders);
	
	if ($update) {
		$update = " ON DUPLICATE KEY UPDATE $primary_key=VALUES( $primary_key ),";
		$cnt    = 0;
		foreach ($row_arrays[0] as $key => $value) {
			if ($cnt == 0) {
				$update .= "$key=VALUES($key)";
				$cnt = 1;
			} else {
				$update .= ", $key=VALUES($key)";
			}
		}
		$query .= $update;
	}
	
	$sql = $wpdb->prepare($query, $values);
	if ($wpdb->query($sql)) {
		return true;
	} else {
		return false;
	}
}

// Add table
add_action('wp_ajax_kpt_addTable', 'kpt_addTable_callback');
function kpt_addTable_callback() {
	if(!current_user_can('edit_posts')){
		return false;
	}
	global $wpdb;
	$options = wp_unslash($_POST['datas']);

	$output = kpt_addTable_insert($options);
	
	// Returning
	$output = json_encode($wpdb->insert_id);

	if(is_array($output)) {
		print_r($output);
	} else{
		echo $output;
	}

	die();
}
function kpt_addTable_insert($options) {
	global $wpdb;
	return $wpdb->insert(
		$wpdb->prefix . 'kpt_tables',
		array(
			'name' => sanitize_title($options['name']),
			'template' => sanitize_title($options['template']),
			'animation' => sanitize_title($options['animation']),
			'hover_effect' => sanitize_title($options['hover_effect']),
			'text_align' => sanitize_title($options['text_align']),
			'enable_top_head_row' => absint($options['enable_top_head_row']),
			'enable_price_row' => absint($options['enable_price_row']),
			'enable_description_row' => absint($options['enable_description_row']),
			'enable_footer_row' => absint($options['enable_footer_row']),
		),
		array(
			'%s',
			'%s',
			'%s',
			'%s',
			'%s',
			'%d',
			'%d',
			'%d',
			'%d',
		)
	);
}

// Edit table
add_action('wp_ajax_kpt_editTable', 'kpt_editTable_callback');
function kpt_editTable_callback() {
	if(!current_user_can('edit_posts')){
		return false;
	}
	global $wpdb;
	$options = wp_unslash($_POST['datas']);
	$table_name = $wpdb->prefix . 'kpt_tables';
		
	$output = $wpdb->update(
		$table_name,
		array(
			'name' => sanitize_title($options['name']),
			'template' => sanitize_title($options['template']),
			'animation' => sanitize_title($options['animation']),
			'hover_effect' => sanitize_title($options['hover_effect']),
			'text_align' => sanitize_title($options['text_align']),
			'enable_top_head_row' => absint($options['enable_top_head_row']),
			'enable_price_row' => absint($options['enable_price_row']),
			'enable_description_row' => absint($options['enable_description_row']),
			'enable_footer_row' => absint($options['enable_footer_row']),
		),
		array('id' => $options['id']), 
		array(
			'%s',
			'%s',
			'%s',
			'%s',
			'%s',
			'%d',
			'%d',
			'%d',
			'%d',
		),
		array('%d')
	);
	
	// Returning
	$output = json_encode($output);
	if(is_array($output)) print_r($output);
	else echo $output;
	
	die();
}

// Edit panes. Receives an array with all the panes options. Delete al the old panes then recreate them
add_action('wp_ajax_kpt_editPanes', 'kpt_editPanes_callback');
function kpt_editPanes_callback() {
	if(!current_user_can('edit_posts')){
		return false;
	}
	global $wpdb;
	$options = wp_unslash($_POST['datas']);
	$table_name = $wpdb->prefix . 'kpt_panes';
	
	$output = true;
	
	// Remove all the old panes
	$output = $wpdb->delete($table_name, array('table_parent' => absint($options['table_parent'])), array('%d'));
	if($output === false) {
		echo json_encode(false);
	} else {
		// It's impossible to have 0 panes (jQuery checks it)
		$output = kpt_insert_rows($options['options'], $table_name);
		
		// Returning
		$output = json_encode($output);

		if(is_array($output)) {
			print_r($output);
		} else { 
			echo $output;
		}
	}
	
	die();
}

add_action('wp_ajax_kpt_editTablerows', 'kpt_editTablerows_callback');
function kpt_editTablerows_callback() {
	global $wpdb;
	$options = $_POST['datas'];
	$table_name = $wpdb->prefix . 'kpt_tablerows';
	
	$output = true;	
	
	$output = $wpdb->delete($table_name, array('table_parent' => $options['table_parent']), array('%d'));

	if($output === false) {
		echo json_encode(false);
	} else {
		$option_temp = json_decode(stripslashes($options['options']));
		if(empty($option_temp)) {
			echo json_encode(true);
		} else {	
			// Insert row per row
			$options_array = json_decode(stripslashes($options['options']));
			$output = kpt_insert_rows($options_array, $table_name);

			// Returning
			$output = json_encode($output);

			if(is_array($output)) {
				print_r($output);
			} else {
				echo $output;
			}
		}
	}
	
	die();
}

// Delete table and its content
add_action('wp_ajax_kpt_deleteTable', 'kpt_deleteTable_callback');
function kpt_deleteTable_callback() {
	global $wpdb;
	$options = $_POST['datas'];
	
	$real_output = true;
	
	// Delete table
	$table_name = $wpdb->prefix . 'kpt_tables';		
	$output = $wpdb->delete($table_name, array('id' => $options['id']), array('%d'));
	if($output === false) {
		$real_output = false;
	}
	
	// Delete panes
	$table_name = $wpdb->prefix . 'kpt_panes';		
	$output = $wpdb->delete($table_name, array('table_parent' => $options['id']), array('%d'));
	if($output === false) {
		$real_output = false;
	}
	
	// Delete rows
	$table_name = $wpdb->prefix . 'kpt_tablerows';		
	$output = $wpdb->delete($table_name, array('table_parent' => $options['id']), array('%d'));
	if($output === false) {
		$real_output = false;
	}
	
	// Returning
	$real_output = json_encode($real_output);
	if(is_array($real_output)) print_r($real_output);
	else echo $real_output;
	
	die();
}

// Duplicate table and its content
add_action('wp_ajax_kpt_duplicateTable', 'kpt_duplicateTable_callback');
function kpt_duplicateTable_callback() {
	global $wpdb;
	$options = $_POST['datas'];
	
	$output = true;
	$real_output = true;
	
	$table_id = $options['id'];
	
	$cloned_table_name = '';
	
	$tables = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'kpt_tables WHERE id = \'' . $table_id . '\'', ARRAY_A);
	foreach($tables as $table) {
		$cloned_table_name = $table['name'] = $table['name'] . '_' . __('Copy', 'kpt');
		$output = kpt_addtable_insert($table);
	}
	
	if($output === false) {
		$real_output = false;
	} else {
		$cloned_table_id = $wpdb->insert_id;
		
		// Clone panes
		$panes = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'kpt_panes WHERE table_parent = ' . $table_id . ' ORDER BY position', ARRAY_A);
		if(empty($panes)) {
			$output = true;
		}
		else {
			foreach($panes as $key => $slide) {
				unset($panes[$key]['id']);
				$panes[$key]['table_parent'] = $cloned_table_id;
			}
			$temp = kpt_insert_rows($panes, $wpdb->prefix . 'kpt_panes');
			if($temp === false) {
				$output = false;
			}
		}
		
		// Clone rows
		$tablerows = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'kpt_tablerows WHERE table_parent = ' . $table_id, ARRAY_A);
		if(empty($tablerows)) {
			$output = true;
		}
		else {
			foreach($tablerows as $key => $element) {
				unset($tablerows[$key]['id']);
				$tablerows[$key]['table_parent'] = $cloned_table_id;
			}
			$temp = kpt_insert_rows($tablerows, $wpdb->prefix . 'kpt_tablerows');
			if($temp === false) {
				$output = false;
			}
			
			if($output === false) {
				$real_output = false;
			}
		}
	}
	
	if($real_output === true) {
		$real_output = array(
			'response' => true,
			'cloned_table_id' => $cloned_table_id,
			'cloned_table_name' => $cloned_table_name,
		);
	} else {
		$real_output = array(
			'response' => false,
			'cloned_table_id' => false,
			'cloned_table_name' => false,
		);
	}
	
	// Returning
	$real_output = json_encode($real_output);
	if(is_array($real_output)) print_r($real_output);
	else echo $real_output;
	
	die();
}

// Exports the table in xml
add_action('wp_ajax_kpt_exportTable', 'kpt_exportTable_callback');
function kpt_exportTable_callback() {
	global $wpdb;
	if(!current_user_can('edit_posts')){
		return false;
	}
	// Clear the temp folder
	array_map('unlink', glob(KADENCE_PT_PATH . '/temp/*'));
	
	$options = wp_unslash($_POST['datas']);
	
	$real_output = true;
	
	$result = array();
	
	// Get the Table
	$table = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'kpt_tables WHERE id = \'' . absint($options['id']) . '\'', ARRAY_A);
	if(empty($table)) {
		$real_output = false;
	} else {
		foreach($table as $key => $temp) {
			unset($table[$key]['id']);
		}
		$result['tables'] = $table;
	}
	$table_slug = strtolower(preg_replace('/[^a-zA-Z0-9-_\.]/','', $table[0]['name']));
	$zip = new ZipArchive();
	$filename = 'kpt-' . $table_slug . '.zip';
	if($zip->open(KADENCE_PT_PATH . '/temp/' . $filename, ZipArchive::CREATE) !== TRUE) {
		echo false;
		die();
	}
	
	// Get the panes
	$panes = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'kpt_panes WHERE table_parent = ' . absint($options['id']) . ' ORDER BY position', ARRAY_A);
	if(! empty($panes)) {
		foreach($panes as $key => $temp) {
			unset($panes[$key]['id']);
			unset($panes[$key]['table_parent']);
			
			// Add images to zip and remove media directory URLs
			if(!empty($panes[$key]['top_head_image']) && $panes[$key]['top_head_image'] != 'none' && $panes[$key]['top_head_image'] != 'undefined') {
				$img = $panes[$key]['top_head_image'];
				$zip->addFromString(basename($img), file_get_contents($img));
				$panes[$key]['top_head_image'] = basename($img);
			}
		}
		$result['panes'] = $panes;
	}
	
	// Get the rows
	$tablerows = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'kpt_tablerows WHERE table_parent = ' . absint($options['id']), ARRAY_A);
	if(! empty($tablerows )) {
		foreach($tablerows as $key => $temp) {
			unset($tablerows[$key]['id']);
			unset($tablerows[$key]['table_parent']);
			
		}
		$result['tablerows'] = $tablerows;
	}
	
	$json = json_encode($result);	
	$zip->addFromString("table.json", $json);
	
	$zip->close();
	
	if($real_output === true) {
		$real_output = array(
			'response' => true,
			'url' => KADENCE_PT_URL . '/temp/' . $filename,
		);
	} else {
		$real_output = array(
			'response' => false,
			'url' => false,
		);
	}
	
	// Returning
	$real_output = json_encode($real_output);
	if(is_array($real_output)) print_r($real_output);
	else echo $real_output;
	
	die();
}

// Inport the table from a json string
add_action('wp_ajax_kpt_importTable', 'kpt_importTable_callback');
function kpt_importTable_callback() {
	global $wpdb;
	if(!current_user_can('edit_posts')){
		return false;
	}
	// Clear the temp folder
	array_map('unlink', glob(KADENCE_PT_PATH . '/temp/*'));
	
	foreach($_FILES as $file) {		
		$output = true;
		$real_output = true;
		
		$zip = new ZipArchive();
		if($zip->open($file['tmp_name']) !== TRUE) {
			echo false;
			die();
		}
		
		$zip->extractTo(KADENCE_PT_PATH . '/temp/');
		
		$imported_array = json_decode(file_get_contents(KADENCE_PT_PATH . '/temp/table.json'));
		
		$tables = $imported_array->tables;
		foreach($tables as $table) {
			$output = kpt_addTable_insert((array) $table);
		}
		
		if($output === false) {
			$real_output = false;
		} else {
			$imported_table_id = $wpdb->insert_id;
			
			// Import panes
			$panes = $imported_array->panes;
			if(empty($panes)) {
				$output = true;
			} else {
				foreach($panes as $key => $slide) {
					$panes[$key]->table_parent = $imported_table_id;
					
					// Set background images
					if(!empty($panes[$key]->top_head_image) && $panes[$key]->top_head_image != 'undefined' && $panes[$key]->top_head_image != 'none') {
						$upload = media_sideload_image(KADENCE_PT_URL . '/temp/' . $panes[$key]->top_head_image, 0, null, 'src');
						$panes[$key]->top_head_image = $upload;
					}
				}
				$temp = kpt_insert_rows($panes, $wpdb->prefix . 'kpt_panes');
				if($temp === false) {
					$output = false;
				}
			}
			
			// Import rows
			$tablerows = (array) $imported_array->tablerows;
			if(empty($tablerows)) {
				$output = true;
			} else {
				foreach($tablerows as $key => $element) {
					$tablerows[$key]->table_parent = $imported_table_id;
					
				}
				$temp = kpt_insert_rows($tablerows, $wpdb->prefix . 'kpt_tablerows');
				if($temp === false) {
					$output = false;
				}
				
				if($output === false) {
					$real_output = false;
				}
			}
		}
		
		if($real_output === true) {
			$real_output = array(
				'response' => true,
				'imported_table_id' => $imported_table_id,
				'imported_table_name' => $imported_array->tables[0]->name,
			);
		} else {
			$real_output = array(
				'response' => false,
				'imported_table_id' => false,
				'imported_table_name' => false,
			);
		}
		
		// Returning
		$real_output = json_encode($real_output);
		if(is_array($real_output)) print_r($real_output);
		else echo $real_output;
		
		die();
	}
}
add_action('wp_ajax_kpt_importTemplateTable', 'kpt_importTable_template_callback');
function kpt_importTable_template_callback() {
	global $wpdb;
	if(!current_user_can('edit_posts')){
		return false;
	}
	$options = wp_unslash($_POST['datas']);
	
	if(empty( $options['file'] ) ) {
		die();
	}
	$output = true;
		$real_output = true;
	$imported_array = json_decode(file_get_contents(KADENCE_PT_PATH . 'admin/templates/'.esc_attr($options['file']).'.json'));

		$tables = $imported_array->tables;
		foreach($tables as $table) {
			$output = kpt_addTable_insert((array) $table);
		}
		
		if($output === false) {
			$real_output = false;
		} else {
			$imported_table_id = $wpdb->insert_id;
			
			// Import panes
			$panes = $imported_array->panes;
			if(empty($panes)) {
				$output = true;
			} else {
				foreach($panes as $key => $slide) {
					$panes[$key]->table_parent = $imported_table_id;
				}
				$temp = kpt_insert_rows($panes, $wpdb->prefix . 'kpt_panes');
				if($temp === false) {
					$output = false;
				}
			}
			
			// Import rows
			$tablerows = (array) $imported_array->tablerows;
			if(empty($tablerows)) {
				$output = true;
			} else {
				foreach($tablerows as $key => $element) {
					$tablerows[$key]->table_parent = $imported_table_id;
					
				}
				$temp = kpt_insert_rows($tablerows, $wpdb->prefix . 'kpt_tablerows');
				if($temp === false) {
					$output = false;
				}
				
				if($output === false) {
					$real_output = false;
				}
			}
		}
		
		if($real_output === true) {
			$real_output = array(
				'response' => true,
				'imported_table_id' => $imported_table_id,
				'imported_table_name' => $imported_array->tables[0]->name,
			);
		} else {
			$real_output = array(
				'response' => false,
				'imported_table_id' => false,
				'imported_table_name' => false,
			);
		}
		
		// Returning
		$real_output = json_encode($real_output);
		if(is_array($real_output)) print_r($real_output);
		else echo $real_output;
		
		die();
}