<?php

class KadencePTDatabase {

	public static function setVersion() {
		update_option('kpt_version', KADENCE_PT_VERSION);
	}

	// Creates or updates all the Settings
	public static function setDatabase() {
		self::setTablesDatabase();
		self::setPanesDatabase();
		self::setTableRowsDatabase();
	}

	public static function setTablesDatabase() {
		global $wpdb;
		$table_name = $wpdb->prefix . 'kpt_tables';
		
		$sql = "CREATE TABLE $table_name (
		id mediumint(9) NOT NULL AUTO_INCREMENT,
		name TEXT CHARACTER SET utf8,
		template TEXT CHARACTER SET utf8,
		animation TEXT CHARACTER SET utf8,
		hover_effect TEXT CHARACTER SET utf8,
		text_align TEXT CHARACTER SET utf8,
		enable_top_head_row INT,
		enable_price_row INT,
		enable_description_row INT,
		enable_footer_row INT,
		UNIQUE KEY id (id)
		);";
		
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($sql);
	}

	// Warning: the time variable is a string because it could contain the 'all' word
	public static function setPanesDatabase() {
		global $wpdb;
		$table_name = $wpdb->prefix . 'kpt_panes';
		
		$sql = "CREATE TABLE $table_name (
		id mediumint(9) NOT NULL AUTO_INCREMENT,
		table_parent mediumint(9),
		position INT,
		top_head_background TEXT CHARACTER SET utf8,
		top_head_color TEXT CHARACTER SET utf8,
		top_head_font_size INT,
		top_head_letter_spacing INT,
		top_head_line_height TEXT CHARACTER SET utf8,
		top_head_font TEXT CHARACTER SET utf8,
		top_head_height INT,
		top_head_padding INT,
		top_head_html TEXT CHARACTER SET utf8,
		top_head_icon TEXT CHARACTER SET utf8,
		top_head_image TEXT CHARACTER SET utf8,
		price_background TEXT CHARACTER SET utf8,
		price_color TEXT CHARACTER SET utf8,
		price_font_size INT,
		price_letter_spacing INT,
		price_line_height TEXT CHARACTER SET utf8,
		price_font TEXT CHARACTER SET utf8,
		price_sub_color TEXT CHARACTER SET utf8,
		price_sub_font_size INT,
		price_sub_letter_spacing INT,
		price_sub_line_height TEXT CHARACTER SET utf8,
		price_sub_font TEXT CHARACTER SET utf8,
		price_padding INT,
		price_height INT,
		price_html TEXT CHARACTER SET utf8,
		price_sub_html TEXT CHARACTER SET utf8,
		description_background TEXT CHARACTER SET utf8,
		description_color TEXT CHARACTER SET utf8,
		description_font_size INT,
		description_letter_spacing INT,
		description_line_height TEXT CHARACTER SET utf8,
		description_font TEXT CHARACTER SET utf8,
		description_padding INT,
		description_height INT,
		description_html TEXT CHARACTER SET utf8,
		footer_background TEXT CHARACTER SET utf8,
		footer_color TEXT CHARACTER SET utf8,
		footer_color_hover TEXT CHARACTER SET utf8,
		footer_font_size INT,
		footer_letter_spacing INT,
		footer_line_height TEXT CHARACTER SET utf8,
		footer_btn_background TEXT CHARACTER SET utf8,
		footer_btn_background_hover TEXT CHARACTER SET utf8,
		footer_btn_border_color TEXT CHARACTER SET utf8,
		footer_btn_border_color_hover TEXT CHARACTER SET utf8,
		footer_btn_border_width INT,
		footer_btn_border_radius INT,
		footer_btn_padding INT,
		footer_font TEXT CHARACTER SET utf8,
		footer_height INT,
		footer_link TEXT CHARACTER SET utf8 DEFAULT '',
		footer_link_new_tab INT DEFAULT 0,
		footer_html TEXT CHARACTER SET utf8,
		featured_background TEXT CHARACTER SET utf8,
		featured_color TEXT CHARACTER SET utf8,
		featured TEXT CHARACTER SET utf8,
		featured_text TEXT CHARACTER SET utf8,
		featured_font_size INT,
		featured_letter_spacing INT,
		featured_font TEXT CHARACTER SET utf8,
		featured_line_height TEXT CHARACTER SET utf8,
		featured_border_color TEXT CHARACTER SET utf8,
		featured_border_width INT,
		featured_border_radius INT,
		featured_size INT,
		UNIQUE KEY id (id)
		);";
		
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($sql);
	}

	public static function setTableRowsDatabase() {
		global $wpdb;
		$table_name = $wpdb->prefix . 'kpt_tablerows';
		
		$sql = "CREATE TABLE $table_name (
		id mediumint(9) NOT NULL AUTO_INCREMENT,
		table_parent mediumint(9),
		pane_parent mediumint(9),
		position INT,
		inner_html TEXT CHARACTER SET utf8,
		icon TEXT CHARACTER SET utf8,
		image TEXT CHARACTER SET utf8,
		height INT,
		padding INT,
		color TEXT CHARACTER SET utf8,
		background TEXT CHARACTER SET utf8,
		letter_spacing INT,
		font_size INT,
		line_height TEXT CHARACTER SET utf8,
		font TEXT CHARACTER SET utf8,
		UNIQUE KEY id (id)
		);";
		
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($sql);
	}
}

?>