

(function (original) {
  jQuery.fn.ksp_betterClone = function () {
    var result           = original.apply(this, arguments),
        my_textareas     = this.find('textarea').add(this.filter('textarea')),
        result_textareas = result.find('textarea').add(result.filter('textarea')),
        my_selects       = this.find('select').add(this.filter('select')),
        result_selects   = result.find('select').add(result.filter('select'));

    for (var i = 0, l = my_textareas.length; i < l; ++i) jQuery(result_textareas[i]).val(jQuery(my_textareas[i]).val());
    for (var i = 0, l = my_selects.length;   i < l; ++i) {
      for (var j = 0, m = my_selects[i].options.length; j < m; ++j) {
        if (my_selects[i].options[j].selected === true) {
          result_selects[i].options[j].selected = true;
        }
      }
    }
    return result;
  };
}) (jQuery.fn.clone);


(function($) {
    $(window).load(function() {

        
        function ksp_showSuccess() {
            var overlay = $(document.getElementById('kt_ajax_overlay'));
            overlay.fadeOut();
            var target = $('.kpt-admin .ksp-message.ksp-message-ok');
            target.css({
                'display' : 'block',
                'opacity' : 0,
            });
            target.animate({
                'opacity' : 1,
            }, 300)
            .delay(2000)
            .animate({
                'opacity' : 0,
            }, 300, function() {
                target.css('display', 'none');
            });
        }
        
        function ksp_showError() {
            var overlay = $(document.getElementById('kt_ajax_overlay'));
            overlay.fadeOut();
            var target = $('.kpt-admin .ksp-message.ksp-message-error');
            target.css({
                'display' : 'block',
                'opacity' : 0,
            });
            target.animate({
                'opacity' : 1,
            }, 300)
            .delay(2000)
            .animate({
                'opacity' : 0,
            }, 300, function() {
                target.css('display', 'none');
            });
        }

        // Skin
        $('.kpt-admin').on('change', '#kpt-table-settings select#kpt-template', function() {
            $(this).closest('.kpt-table').find('#kpt-panes-settings ul.ksp-sortable').removeClass('table-skin-flatmargin');
            $(this).closest('.kpt-table').find('#kpt-panes-settings ul.ksp-sortable').removeClass('table-skin-flat');
            $(this).closest('.kpt-table').find('#kpt-panes-settings ul.ksp-sortable').addClass('table-skin-'+$(this).find(':selected').val());
        });
       
        // Text Align
        $('.kpt-admin').on('change', '#kpt-table-settings select#kpt-text_align', function() {
            $(this).closest('.kpt-table').find('#kpt-panes-settings ul.ksp-sortable').removeClass('table-align-center');
            $(this).closest('.kpt-table').find('#kpt-panes-settings ul.ksp-sortable').removeClass('table-align-left');
            $(this).closest('.kpt-table').find('#kpt-panes-settings ul.ksp-sortable').removeClass('table-align-right');
            $(this).closest('.kpt-table').find('#kpt-panes-settings ul.ksp-sortable').addClass('table-align-'+$(this).find(':selected').val());
        });

        // Hover
        $('.kpt-admin').on('change', '#kpt-table-settings select#kpt-hover', function() {
            $(this).closest('.kpt-table').find('#kpt-panes-settings ul.ksp-sortable').removeClass('table-hover-none');
            $(this).closest('.kpt-table').find('#kpt-panes-settings ul.ksp-sortable').removeClass('table-hover-grow');
            $(this).closest('.kpt-table').find('#kpt-panes-settings ul.ksp-sortable').removeClass('table-hover-boxshadow');
            $(this).closest('.kpt-table').find('#kpt-panes-settings ul.ksp-sortable').addClass('table-hover-'+$(this).find(':selected').val());
        });
        /************/
        /** Panes **/
        /************/
        
        var panes_number = $('.kpt-admin #kpt-panes .kpt-table-editing-area li').length;
        
        // Run sortable
       //  $('.kpt-table-editing-area.ksp-sortable').sortable();
        //$('.kpt-table-editing-area.ksp-sortable').disableSelection();
        
        var slide_before; // Contains the index before the sorting
        var slide_after; // Contains the index after the sorting
        $('.kpt-table-editing-area.ksp-sortable').sortable({
            items: "> li",
            handle: ".pane-controls",
            // Store the actual index
            start: function(event, ui) {
                slide_before = $(ui.item).index();
            },
            
            // Change the pane order based on the new index and rename the tabs
            update: function(event, ui) {

                // Store the new index
                slide_after = $(ui.item).index();

                // Change the pane position
                var pane_settings = $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list:eq(' + slide_before + ')');           
                var pane_after = $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list:eq(' + slide_after + ')');            
                if(slide_before < slide_after) {
                    pane_settings.insertAfter(pane_after);
                } else {
                    pane_settings.insertBefore(pane_after);
                }
                
                // Rename all the tabs
                $('.kpt-admin #kpt-panes .kpt-table-editing-area li.kpt-pane').each(function() {
                    var temp = $(this);
                    if(temp.find('span.kpt-pane-index')) {
                        temp.find('span.kpt-pane-index').text((temp.index() + 1));
                    }
                });
            }
        });
        $('.kpt-table-editing-area.ksp-sortable').disableSelection();
		
        // Show hide top Head Row
         $('#kpt-table-settings #kpt-enable_top_row').change(function() {
            kpt_enable_top_row();
        });
        function kpt_enable_top_row() {
            if( $('#kpt-table-settings #kpt-enable_top_row').length) {
	            	if( $('#kpt-table-settings #kpt-enable_top_row').is(':checked') ) {
		               $('#kpt-panes-settings').find('.kpt-pane-top-head').each(function() {
		                	$(this).show();
		                });
		            } else {
		                $('#kpt-panes-settings').find('.kpt-pane-top-head').each(function() {
		                	$(this).hide();
		                });
		            }
            }
        }
        kpt_enable_top_row();
        // Show Price Row
         $('#kpt-table-settings #kpt-enable_price_row').change(function() {
            kpt_enable_price_row();
        });
        function kpt_enable_price_row() {
            if( $('#kpt-table-settings #kpt-enable_price_row').length) {
	            	if( $('#kpt-table-settings #kpt-enable_price_row').is(':checked') ) {
		               $('#kpt-panes-settings').find('.kpt-pane-price').each(function() {
		                	$(this).show();
		                });
		            } else {
		                $('#kpt-panes-settings').find('.kpt-pane-price').each(function() {
		                	$(this).hide();
		                });
		            }
            }
        }
        kpt_enable_price_row();
        // Show Description Row
         $('#kpt-table-settings #kpt-enable_description_row').change(function() {
            kpt_enable_description_row();
        });
        function kpt_enable_description_row() {
            if( $('#kpt-table-settings #kpt-enable_description_row').length) {
	            	if( $('#kpt-table-settings #kpt-enable_description_row').is(':checked') ) {
		               $('#kpt-panes-settings').find('.kpt-pane-description').each(function() {
		                	$(this).show();
		                });
		            } else {
		                $('#kpt-panes-settings').find('.kpt-pane-description').each(function() {
		                	$(this).hide();
		                });
		            }
            }
        }
        kpt_enable_description_row();
         // Show Footer Row
         $('#kpt-table-settings #kpt-enable_footer_row').change(function() {
            kpt_enable_footer_row();
        });
        function kpt_enable_footer_row() {
            if( $('#kpt-table-settings #kpt-enable_footer_row').length) {
	            	if( $('#kpt-table-settings #kpt-enable_footer_row').is(':checked') ) {
		               $('#kpt-panes-settings').find('.kpt-pane-footer').each(function() {
		                	$(this).show();
		                });
		            } else {
		                $('#kpt-panes-settings').find('.kpt-pane-footer').each(function() {
		                	$(this).hide();
		                });
		            }
            }
        }
        kpt_enable_footer_row();
       
        // Add new
        function kpt_addPane() {
            
            var void_pane = $('.kpt-admin #kpt-panes .kpt-void-pane').html();
            var void_pane_edit = $('.kpt-admin #kpt-panes .kpt-void-pane-edit').html();
            // Create the Pane
            $('.kpt-admin #kpt-panes .kpt-table-editing-area').append(void_pane);
            // Create the settings
            $('.kpt-admin #kpt-panes .pane-settings').append(void_pane_edit);
           
            // Active class
            $('.kpt-admin #kpt-panes ul.ksp-sortable').removeClass('table-pane-count-'+panes_number);
            var index = panes_number;
            panes_number++;
            $('.kpt-admin #kpt-panes ul.ksp-sortable').addClass('table-pane-count-'+panes_number);
            $('.kpt-admin #kpt-panes ul.ksp-sortable .kpt-pane:eq(' + index + ') span.kpt-pane-index').html(panes_number); 
          
            kpt_column_color_picker();
           kpt_top_color_picker();
           kpt_price_color_picker();
           kpt_description_color_picker();
           kpt_footer_color_picker();
           update_row_sort();
        }
        
        // Add new on click
        $('.kpt-admin #kpt-panes-settings .ksp-add-pane').click(function() {
            kpt_addPane();
        }); 
        // Also add a new slide if panes_number == 0
       /*
        if(panes_number == 0) {
            ksp_addSlide();
        } else {
            $('.kpt-admin #kpt-panes .ksp-slide-tabs ul li').eq(0).find('a').click();
        }
        */
        // Delete
        $('.kpt-admin #kpt-panes ul.ksp-sortable li .pane-controls-settings span.ksp-close').live('click', function() {
            if($('.kpt-admin #kpt-panes ul.ksp-sortable li').length <= 1) {
                alert(kpt_translations.pane_delete_just_one);
                return;
            }
        
            var confirm = window.confirm(kpt_translations.pane_delete_confirm);
            if(!confirm) {
                return;
            }
            $('.kpt-admin #kpt-panes ul.ksp-sortable').removeClass('table-pane-count-'+panes_number);
            panes_number--;
             $('.kpt-admin #kpt-panes ul.ksp-sortable').addClass('table-pane-count-'+panes_number);
            var slide_index = $(this).closest('li.kpt-pane').index();
            
            // Remove the slide itself
            $('.kpt-admin #kpt-panes ul.ksp-sortable li.kpt-pane').eq(slide_index).remove();
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list').eq(slide_index).remove();
            
            // Scale back all the slides text
            for(var i = slide_index; i < panes_number; i++) {
                var slide = $('.kpt-admin #kpt-panes ul.ksp-sortable li').eq(i);
                var indx = parseInt(slide.find('.kpt-pane-index').text());
                slide.find('.kpt-pane-index').text(indx - 1);
            }
        });
        // Duplicate
        $('.kpt-admin #kpt-panes ul.ksp-sortable li .pane-controls-settings .ksp-duplicate').live('click', function() {
        	update_row_sort_refreash();         
            var slide_index = $(this).closest('li.kpt-pane').index();
            var pane = $('.kpt-admin #kpt-panes ul.ksp-sortable li.kpt-pane').eq(slide_index);
            var pane_settings = $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list').eq(slide_index);

            $('.kpt-admin #kpt-panes ul.ksp-sortable').removeClass('table-pane-count-'+panes_number);
            // Clone the pane
            pane.ksp_betterClone(true).appendTo(pane.parent());
            // Clone the settings
            pane_settings.ksp_betterClone(true).appendTo(pane_settings.parent());
           	//Destroy the colors
          	$('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list').eq(panes_number).find('.wp-picker-container input[type=text].wp-color-picker').each( function() {
          		$(this).clone().appendTo($(this).closest('.ksp-column')).css('display', 'inline-block').removeClass('wp-color-picker');
          	});
          	$('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list').eq(panes_number).find('.wp-picker-container').each( function() {
          		$(this).remove();
          	});
          		kpt_column_color_picker();
          	 	kpt_top_color_picker();
	           	kpt_price_color_picker();
	           	kpt_description_color_picker();
	           	kpt_footer_color_picker();

          	panes_number++;
          	$('.kpt-admin #kpt-panes ul.ksp-sortable').addClass('table-pane-count-'+panes_number);
          	for(var i = 0; i < panes_number; i++) {
          		var pane = $('.kpt-admin #kpt-panes ul.ksp-sortable li').eq(i);
          		pane.find('.kpt-pane-index').text(i + 1);
          	}
          	update_row_sort();
        });

        // Column Settings

        kpt_column_color_picker();
        
        // Run top section color picker
        function kpt_column_color_picker() {
            //color
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-featured-settings .kpt-featured_color').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item');
                        layer.css('color', ui.color.toString());
                    }
                });
            });
            // Row background
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-featured-settings .kpt-featured_background').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item');
                        var layerinner = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item .kpt-featured_inner');
                        layer.css('background', ui.color.toString());
                        layerinner.css('background', ui.color.toString());
                    }
                });
            });
            // Row background
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-featured-settings .kpt-featured_border_color').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kt-table-pane');
                        layer.css('border-color', ui.color.toString());
                    }
                });
            });
        }
       
        // top Text
        $('.kpt-admin').on('keyup', '.pane-settings .kpt-featured_text', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            var top_text = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item .kpt-featured_inner');

                top_text.html($(this).val());
        });
        // top Font Size
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-featured_font_size', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item').css('font-size', parseFloat($(this).val()));
        });
        // top Line Height
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-featured_line_height', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item').css('line-height', parseFloat($(this).val()) + 'px');
        });
        // Letting Spacing
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-featured_letter_spacing', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item').css('letter-spacing', parseFloat($(this).val()) + 'px');
        });
         // Letting Spacing
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-featured_size', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item').css('height', parseFloat($(this).val()) + 'px');
             $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item').css('width', parseFloat($(this).val()) + 'px');
        });
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-featured_border_width', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kt-table-pane').css('border-width', parseFloat($(this).val()));
        });
        // Font Family and Weight
        $('.kpt-admin').on('change', '.pane-settings .kpt-feature-column', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kt-table-pane').removeClass('kt-pane-style-badge');
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kt-table-pane').removeClass('kt-pane-style-none');
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kt-table-pane').removeClass('kt-pane-style-ribbon');
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kt-table-pane').removeClass('kt-pane-style-scale');
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item').removeClass('featured-style-badge');
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item').removeClass('featured-style-none');
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item').removeClass('featured-style-ribbon');
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item').removeClass('featured-style-scale');

            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item').addClass('featured-style-'+$(this).find(':selected').val());
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kt-table-pane').addClass('kt-pane-style-'+$(this).find(':selected').val());
        });
        // Font Family and Weight
        $('.kpt-admin').on('change', '.pane-settings .kpt-featured_font .kpt-layer-font', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item').css('font-family', $(this).find(':selected').data('family'));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item').css('font-weight', parseFloat($(this).find(':selected').data('weight')));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-featured-item').css('font-style', $(this).find(':selected').data('style'));
        });
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-featured_border_radius', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kt-table-pane').css('border-radius', parseFloat($(this).val()));
        });

        // Top Row

        kpt_top_color_picker();
        
        // Run top section color picker
        function kpt_top_color_picker() {
            //color
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-top-settings .kpt-top_color').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-top-head');
                        layer.css('color', ui.color.toString());
                        layer.mouseout(function() {
                            $(this).css('color', ui.color.toString());
                        });
                    }
                });
            });
            // Row background
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-top-settings .kpt-top_background').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-top-head');
                        layer.css('background', ui.color.toString());
                    }
                });
            });
        }
        // Upload click
        $('.kpt-admin').on('click', '#kpt-panes .pane-settings .kpt-pane-settings-list .pane-top-settings .kpt-image-upload-button', function() {
          	var index = $(this).closest('.kpt-pane-settings-list').index();
          	var settings = $(this);
          	var pane_parent = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ')');
            kpt_upload_image_top(pane_parent, settings);
        });
        
        function kpt_upload_image_top(pane_parent, settings) {
            var area = pane_parent.find('.kpt-pane-top-head .kpt-top-head-image');
            if( area.find('.kpt-top-image').length) {

            } else {
            	area.append('<img class="kpt-top-image" src="" />');
            }
            var file_frame;

            // If the media frame already exists, reopen it.
            if ( file_frame ) {
              file_frame.open();
              return;
            }

            // Create the media frame.
            file_frame = wp.media.frames.file_frame = wp.media({
              title: jQuery( this ).data( 'uploader_title' ),
              button: {
                text: jQuery( this ).data( 'uploader_button_text' ),
              },
              multiple: false  // Set to true to allow multiple files to be selected
            });

            // When an image is selected, run a callback.
            file_frame.on( 'select', function() {
              // We set multiple to false so only get one image from the uploader
              attachment = file_frame.state().get('selection').first().toJSON();

              // Do something with attachment.id and/or attachment.url here
              var image_src = attachment.url;
              var image_alt = attachment.alt;
              
              // Set attributes. If is a link, do the right thing
              var image = area.find('.kpt-top-image');
              
                  image.attr('src', image_src);

                  settings.attr('data-src', image_src);
                  settings.attr('value', 'Edit Image');
                  settings.parent().append('<input class="kpt-image-remove-button ksp-button ksp-is-default" type="button" value="Remove Image" />');
              
            });

            // Finally, open the modal
            file_frame.open();
        }
        // Remove Image
        $('.kpt-admin').on('click', '#kpt-panes .kpt-pane-settings-list .pane-top-settings .kpt-image-remove-button', function() {
        	var index = $(this).closest('.kpt-pane-settings-list').index();
          	$(this).closest('.kpt-top_image').find('.kpt-image-upload-button').attr('data-src', '');
          	$(this).closest('.kpt-top_image').find('.kpt-image-upload-button').attr('value', 'Add Image');
          	$(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') img.kpt-top-image').remove();
          	$(this).remove();
        });
        // PANE EDIt:
        // top Text
        $('.kpt-admin').on('keyup', '.pane-settings .kpt-top_html', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            var top_text = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-top-head');

                top_text.html($(this).val());
        });
        // top Font Size
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-top_font_size', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-top-head').css('font-size', parseFloat($(this).val()));
        });
        // top Line Height
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-top_line_height', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-top-head').css('line-height', parseFloat($(this).val()) + 'px');
        });
        // Letting Spacing
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-top_letter_spacing', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-top-head').css('letter-spacing', parseFloat($(this).val()) + 'px');
        });
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-top_padding', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-top-head').css('padding-top', parseFloat($(this).val()));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-top-head').css('padding-bottom', parseFloat($(this).val()));
        });
        // Font Family and Weight
        $('.kpt-admin').on('change', '.pane-settings .kpt-top_font .kpt-layer-font', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-top-head').css('font-family', $(this).find(':selected').data('family'));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-top-head').css('font-weight', parseFloat($(this).find(':selected').data('weight')));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-top-head').css('font-style', $(this).find(':selected').data('style'));
        });
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-top_height', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-top-head').css('min-height', parseFloat($(this).val()));
        });

        // price Row

        kpt_price_color_picker();
        
        // Run footer section color picker
        function kpt_price_color_picker() {
            //color
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-price-settings .kpt-price_color').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price');
                        layer.css('color', ui.color.toString());
                        layer.mouseout(function() {
                            $(this).css('color', ui.color.toString());
                        });
                    }
                });
            });
            //color
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-price-settings .kpt-price_sub_color').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price .kpt-price-sub');
                        layer.css('color', ui.color.toString());
                        layer.mouseout(function() {
                            $(this).css('color', ui.color.toString());
                        });
                    }
                });
            });
            // Row background
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-price-settings .kpt-price_background').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price');
                        layer.css('background', ui.color.toString());
                    }
                });
            });
        }
         
        // PANE EDIt:
        // price Text
        $('.kpt-admin').on('keyup', '.pane-settings .kpt-price_html', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            var price_text = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price .kpt-price-inner');

                price_text.html($(this).val());
        });
        // price Font Size
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-price_font_size', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price').css('font-size', parseFloat($(this).val()));
        });
        // price Line Height
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-price_line_height', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price').css('line-height', parseFloat($(this).val()) + 'px');
        });
        // Letting Spacing
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-price_letter_spacing', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price').css('letter-spacing', parseFloat($(this).val()) + 'px');
        });
        // Font Family and Weight
        $('.kpt-admin').on('change', '.pane-settings .kpt-price_font .kpt-layer-font', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price').css('font-family', $(this).find(':selected').data('family'));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price').css('font-weight', parseFloat($(this).find(':selected').data('weight')));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price').css('font-style', $(this).find(':selected').data('style'));
        });
        // price Text
        $('.kpt-admin').on('keyup', '.pane-settings .kpt-price_sub_html', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            var price_text = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price .kpt-price-sub');

                price_text.html($(this).val());
        });
        // price Font Size
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-price_sub_font_size', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price .kpt-price-sub').css('font-size', parseFloat($(this).val()));
        });
        // price Line Height
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-price_sub_line_height', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price .kpt-price-sub').css('line-height', parseFloat($(this).val()) + 'px');
        });
        // Letting Spacing
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-price_sub_letter_spacing', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price .kpt-price-sub').css('letter-spacing', parseFloat($(this).val()) + 'px');
        });
        // Font Family and Weight
        $('.kpt-admin').on('change', '.pane-settings .kpt-price_sub_font .kpt-layer-font', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price .kpt-price-sub').css('font-family', $(this).find(':selected').data('family'));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price .kpt-price-sub').css('font-weight', parseFloat($(this).find(':selected').data('weight')));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price .kpt-price-sub').css('font-style', $(this).find(':selected').data('style'));
        });
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-price_padding', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price').css('padding-top', parseFloat($(this).val()));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price').css('padding-bottom', parseFloat($(this).val()));
        });
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-price_height', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-price').css('min-height', parseFloat($(this).val()));
        });


        // Description Row

        kpt_description_color_picker();
        
        // Run footer section color picker
        function kpt_description_color_picker() {
            //color
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-description-settings .kpt-description_color').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-description');
                        layer.css('color', ui.color.toString());
                        layer.mouseout(function() {
                            $(this).css('color', ui.color.toString());
                        });
                    }
                });
            });
            // Row background
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-description-settings .kpt-description_background').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-description');
                        layer.css('background', ui.color.toString());
                    }
                });
            });
        }
         
        // PANE EDIt:
        // description Text
        $('.kpt-admin').on('keyup', '.pane-settings .kpt-description_html', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            var description_text = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-description');

                description_text.html($(this).val());
        });
        // description Font Size
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-description_font_size', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-description').css('font-size', parseFloat($(this).val()));
        });
        // description Line Height
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-description_line_height', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-description').css('line-height', parseFloat($(this).val()) + 'px');
        });
        // Letting Spacing
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-description_letter_spacing', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-description').css('letter-spacing', parseFloat($(this).val()) + 'px');
        });
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-description_padding', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-description').css('padding-top', parseFloat($(this).val()));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-description').css('padding-bottom', parseFloat($(this).val()));
        });
        // Font Family and Weight
        $('.kpt-admin').on('change', '.pane-settings .kpt-description_font .kpt-layer-font', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-description').css('font-family', $(this).find(':selected').data('family'));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-description').css('font-weight', parseFloat($(this).find(':selected').data('weight')));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-description').css('font-style', $(this).find(':selected').data('style'));
        });
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-description_height', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-description').css('min-height', parseFloat($(this).val()));
        });


         // Footer button
        $( ".kpt-footer-btn" ).each(function() {
            $(this).mouseover(function() {
                $(this).css('color', $(this).data('hcolor'));
                $(this).css('border-color', $(this).data('hborder-color'));
                $(this).css('background', $(this).data('hbackground-color'));
            });
            $(this).mouseout(function() {
                $(this).css('color', $(this).data('color'));
                $(this).css('border-color', $(this).data('border-color'));
                $(this).css('background', $(this).data('background-color'));
            });
        });
        kpt_footer_color_picker();
        
        // Run footer section color picker
        function kpt_footer_color_picker() {
            //color
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-footer-settings .kpt-footer_color').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-footer-btn');
                        layer.css('color', ui.color.toString());
                        layer.mouseout(function() {
                            $(this).css('color', ui.color.toString());
                        });
                    }
                });
            });
            // color hover
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-footer-settings .kpt-footer_color_hover').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-footer-btn');
                        layer.attr('data-hcolor', ui.color.toString());
                        layer.mouseover(function() {
                            $(this).css('color', ui.color.toString());
                        });
                    }
                });
            });
            // background
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-footer-settings .kpt-footer_btn_background').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-footer-btn');
                        layer.css('background', ui.color.toString());
                        layer.mouseout(function() {
                            $(this).css('background', ui.color.toString());
                        });
                    }
                });
            });
            // background hover
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-footer-settings .kpt-footer_btn_background_hover').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-footer-btn');
                        layer.attr('data-hbackground-color', ui.color.toString());
                        layer.mouseover(function() {
                            $(this).css('background', ui.color.toString());
                        });
                    }
                });
            });
            // border hover
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-footer-settings .kpt-footer_btn_border_color').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-footer-btn');
                        layer.css('border-color', ui.color.toString());
                        layer.mouseout(function() {
                            $(this).css('border-color', ui.color.toString());
                        });
                    }
                });
            });
            // border hover
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-footer-settings .kpt-footer_btn_border_color_hover').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-footer-btn');
                        layer.attr('data-hborder-color', ui.color.toString());
                        layer.mouseover(function() {
                            $(this).css('border-color', ui.color.toString());
                        });
                    }
                });
            });
            // Row background
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-footer-settings .kpt-footer_background').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-footer');
                        layer.css('background', ui.color.toString());
                    }
                });
            });
        }
         
        // PANE EDIt:
        // Footer Text
        $('.kpt-admin').on('keyup', '.pane-settings .kpt-footer_html', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            var footer_text = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-footer .kpt-footer-btn');

                footer_text.html($(this).val());
        });
        // Footer Font Size
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-footer_font_size', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-footer .kpt-footer-btn').css('font-size', parseFloat($(this).val()));
        });
        // Footer Line Height
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-footer_line_height', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-footer .kpt-footer-btn').css('line-height', parseFloat($(this).val()) + 'px');
        });
        // Letting Spacing
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-footer_letter_spacing', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-footer .kpt-footer-btn').css('letter-spacing', parseFloat($(this).val()) + 'px');
        });
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-footer_btn_border_width', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-footer .kpt-footer-btn').css('border-width', parseFloat($(this).val()));
        });
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-footer_btn_border_radius', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-footer .kpt-footer-btn').css('border-radius', parseFloat($(this).val()));
        });
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-footer_btn_padding', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-footer .kpt-footer-btn').css('padding-left', parseFloat($(this).val()));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-footer .kpt-footer-btn').css('padding-right', parseFloat($(this).val()));
        });
        // Font Family and Weight
        $('.kpt-admin').on('change', '.pane-settings .kpt-footer_font .kpt-layer-font', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-footer .kpt-footer-btn').css('font-family', $(this).find(':selected').data('family'));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-footer .kpt-footer-btn').css('font-weight', parseFloat($(this).find(':selected').data('weight')));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-footer .kpt-footer-btn').css('font-style', $(this).find(':selected').data('style'));
        });
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-footer_height', function() {
            var index = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index + ') .kpt-pane-footer').css('height', parseFloat($(this).val()));
        });

        // Selects Editable area, shows its options
        $('.kpt-admin #kpt-panes').on('click', '.kpt-table-editing-area .kpt-section', function(e) {
            // Do not click the editing-area
            e.stopPropagation();
            
            // Do not open links
            e.preventDefault();
            
            ksp_select_section($(this));
        });
        function ksp_select_section(section) {
            var section_index = section.index();
            var pane_index = section.closest('li.kpt-pane').index();       
            var options = $('#kpt-panes').find('.pane-settings');
            // Hide all options - .active class
            options.find('.pane-settings-contain').css('display', 'none');
            options.find('.pane-settings-contain').removeClass('active');
            
            // Show the correct options + .active class
            options.find('.kpt-pane-settings-list:eq(' + pane_index + ') .pane-settings-contain:eq(' + section_index + ')').css('display', 'block');
            options.find('.kpt-pane-settings-list:eq(' + pane_index + ') .pane-settings-contain:eq(' + section_index + ')').addClass('active');
            
            // Add .active class to the layer in the editing area
            section.closest('ul.ksp-sortable').find('.active').removeClass('active');
            section.addClass('active');
            
        }
        $('.kpt-admin #kpt-panes').on('click', '.kpt-table-editing-area .pane-controls', function(e) {
            // Do not click the editing-area
            e.stopPropagation();
            
            // Do not open links
            e.preventDefault();
            
            ksp_select_column($(this));
        });
        function ksp_select_column(section) {
            var section_index = section.index();
            var pane_index = section.closest('li.kpt-pane').index();       
            var options = $('#kpt-panes').find('.pane-settings');
            // Hide all options - .active class
            options.find('.pane-settings-contain').css('display', 'none');
            options.find('.pane-settings-contain').removeClass('active');
            
            // Show the correct options + .active class
            options.find('.kpt-pane-settings-list:eq(' + pane_index + ') .pane-featured-settings').css('display', 'block');
            options.find('.kpt-pane-settings-list:eq(' + pane_index + ') .pane-featured-settings').addClass('active');
            
            // Add .active class to the layer in the editing area
            section.closest('ul.ksp-sortable').find('.active').removeClass('active');
            section.addClass('active');
            
        }
        
        // Deselect sections
        $('.kpt-admin').on('click', '.kpt-table-editing-area', function() {
            kpt_deselect_section();
        });
        function kpt_deselect_section() {
            $('.kpt-admin #kpt-panes .kpt-table-editing-area .kpt-section').removeClass('active');
            $('.kpt-admin #kpt-panes .kpt-table-editing-area .kpt-section .kpt-pane-single-row').removeClass('active');
            $('.kpt-admin #kpt-panes .pane-settings-contain').removeClass('active');     
            $('.kpt-admin #kpt-panes .pane-settings-contain').css('display', 'none');        
        }

        /**************/
        /** Rows **/
        /**************/
        
        // GENERAL
        var rowslide_before = '';
        var rowslide_after = '';
        function update_row_sort() {
	         $('.kpt-table-editing-area .kpt-pane-rows.kpt-section').each( function() {
	         	$(this).sortable({
		            items: "> .kpt-pane-single-row",
		            handle: ".kpt-row-drag",
		            // Store the actual index
		            start: function(event, ui) {
		                rowslide_before = $(ui.item).index();
		            },
		            
		            // Change the row order based on the new index and rename the tabs
		            update: function(event, ui) {

		                // Store the new index
		                rowslide_after = $(ui.item).index();
		                var parent_index = $(ui.item).closest('li.kpt-pane').index();
		                // Change the row position
		                var row_settings = $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list:eq(' + parent_index + ') .pane-row-settings .single-row-settings:eq(' + rowslide_before + ')');           
		                var row_after = $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list:eq(' + parent_index + ') .pane-row-settings .single-row-settings:eq(' + rowslide_after + ')');            
		                if(rowslide_before < rowslide_after) {
		                    row_settings.insertAfter(row_after);
		                } else {
		                    row_settings.insertBefore(row_after);
		                }
		                
		                // // Rename all the tabs
		                // $('.kpt-admin #kpt-panes .kpt-table-editing-area li.kpt-pane').each(function() {
		                //     var temp = $(this);
		                //     if(temp.find('span.kpt-pane-index')) {
		                //         temp.find('span.kpt-pane-index').text((temp.index() + 1));
		                //     }
		                // });
		            }
	        	});
	        });
     	}
     	update_row_sort();

     	function update_row_sort_refreash() {
     		$('.kpt-table-editing-area .kpt-pane-rows.kpt-section').each( function() {
	         	$(this).sortable( "destroy" );
	         });
     		//update_row_sort();
     	}

        // Selects an layer, shows its options and makes the delete layer button available
        $('.kpt-admin #kpt-panes').on('click', '.kpt-table-editing-area .kpt-section .kpt-pane-single-row', function(e) {
            // Do not click the editing-area
            e.stopPropagation();
            
            // Do not open links
            e.preventDefault();
            
            ksp_select_single_row($(this));
        });
        function ksp_select_single_row(row) {
            var index = row.index();
            var pane_index = row.closest('li.kpt-pane').index();       
            var options = $('#kpt-panes').find('.pane-settings');

            // Hide all options - .active class
            options.find('.pane-settings-contain .row-settings-contain').css('display', 'none');
            options.find('.pane-settings-contain .row-settings-contain').removeClass('active');
            options.find('.pane-settings-contain').css('display', 'none');
            options.find('.pane-settings-contain.active').removeClass('active');
            
            // Show the correct options + .active class
            options.find('.kpt-pane-settings-list:eq(' + pane_index + ') .pane-row-settings').css('display', 'block');
            options.find('.kpt-pane-settings-list:eq(' + pane_index + ') .pane-row-settings .row-settings-contain:eq(' + index + ')').css('display', 'block');
            options.find('.kpt-pane-settings-list:eq(' + pane_index + ') .pane-row-settings .row-settings-contain:eq(' + index+ ')').addClass('active');
            
            // Add .active class to the layer in the editing area

             // Add .active class to the layer in the editing area
            row.closest('ul.ksp-sortable').find('.active').removeClass('active');
            row.addClass('active');

        }
        // Delete Row.
        $('.kpt-admin #kpt-panes').on('click', '.kpt-table-editing-area .kpt-section .kpt-pane-single-row .row-controls .kpt-row-close', function(e) {
        	e.stopPropagation();

        	var parent = $(this).closest('.kpt-pane-rows');    
            if(parent.find('.kpt-pane-single-row').length <= 1) {
                alert(kpt_translations.row_delete_just_one);
                return;
            }
        
            var confirm = window.confirm(kpt_translations.row_delete_confirm);
            if(!confirm) {
                return;
            }
            var index = $(this).closest('.kpt-pane-single-row').index();
            var pane_index = $(this).closest('li.kpt-pane').index();    
            // Remove the row and settings
            $('.kpt-admin #kpt-panes ul.ksp-sortable li.kpt-pane:eq(' + pane_index + ') .kpt-pane-rows .kpt-pane-single-row').eq(index).remove();
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list:eq(' + pane_index + ') .pane-row-settings .single-row-settings').eq(index).remove();
            
        });
        // Duplicate
        $('.kpt-admin #kpt-panes').on('click', '.kpt-table-editing-area .kpt-section .kpt-pane-single-row .row-controls .kpt-row-duplicate', function(e) {
        	e.stopPropagation();
        	var row_index = $(this).closest('.kpt-pane-single-row').index();
            var pane_index =  $(this).closest('li.kpt-pane').index(); 
            var row = $('.kpt-admin #kpt-panes ul.ksp-sortable li.kpt-pane:eq(' + pane_index + ') .kpt-pane-single-row').eq(row_index);
            var row_settings = $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list:eq(' + pane_index + ') .row-settings-contain').eq(row_index);
            var row_count = $('.kpt-admin #kpt-panes ul.ksp-sortable li.kpt-pane:eq(' + pane_index + ') .kpt-pane-single-row').length;
            var options = $('#kpt-panes').find('.pane-settings');
             // Hide all options - .active class
            options.find('.pane-settings-contain .row-settings-contain').css('display', 'none');
            options.find('.pane-settings-contain .row-settings-contain').removeClass('active');
            // Clone the pane
            row.ksp_betterClone(true).appendTo(row.parent());
            // Clone the settings
            row_settings.ksp_betterClone(true).appendTo(row_settings.parent());
           	//Destroy the colors
           	var new_row = $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list:eq(' + pane_index + ') .row-settings-contain').eq(row_count);
           	var new_row_display = $('.kpt-admin #kpt-panes ul.ksp-sortable li.kpt-pane:eq(' + pane_index + ') .kpt-pane-single-row').eq(row_count);

          	new_row.find('.wp-picker-container input[type=text].wp-color-picker').each( function() {
          		$(this).clone().appendTo($(this).closest('.ksp-column')).css('display', 'inline-block').removeClass('wp-color-picker');
          	});
          	new_row.find('.wp-picker-container').each( function() {
          		$(this).remove();
          	});

          	 // Show the correct options + .active class
          	$('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list:eq(' + pane_index + ') .pane-row-settings').css('display', 'block');
            new_row.css('display', 'block');
            new_row.addClass('active');
            
            // Add .active class to the layer in the editing area
            new_row_display.closest('ul.ksp-sortable').find('.active').removeClass('active');
            new_row_display.addClass('active');

          	kpt_row_color_picker();

        });

        kpt_row_color_picker();
        
        // Run footer section color picker
        function kpt_row_color_picker() {
            //color
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-row-settings .kpt-row_color').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.single-row-settings').index();
                        var index_pane = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index_pane + ') .kpt-pane-rows .kpt-pane-single-row').eq(index);
                        layer.css('color', ui.color.toString());
                        layer.mouseout(function() {
                            $(this).css('color', ui.color.toString());
                        });
                    }
                });
            });
            // Row background
            $('.kpt-admin #kpt-panes .pane-settings .kpt-pane-settings-list .pane-row-settings .kpt-row_background').each(function() {
                $(this).wpColorPicker({
                    change: function(event, ui){
                        var index = $(this).closest('.single-row-settings').index();
                        var index_pane = $(this).closest('.kpt-pane-settings-list').index();
                        var layer = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index_pane + ') .kpt-pane-rows .kpt-pane-single-row').eq(index);
                        layer.css('background', ui.color.toString());
                    }
                });
            });
        }
        
        // description Text
        $('.kpt-admin').on('keyup', '.pane-settings .kpt-row_html', function() {
            var index = $(this).closest('.single-row-settings').index();
            var index_pane = $(this).closest('.kpt-pane-settings-list').index();
            var row_text = $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index_pane + ') .kpt-pane-rows .kpt-pane-single-row:eq(' + index + ') .kpt-pane-single-row-inner');

                row_text.html($(this).val());
        });
        // description Font Size
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-row_font_size', function() {
            var index = $(this).closest('.single-row-settings').index();
            var index_pane = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index_pane + ') .kpt-pane-rows .kpt-pane-single-row').eq(index).css('font-size', parseFloat($(this).val()));
        });
        // description Line Height
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-row_line_height', function() {
           var index = $(this).closest('.single-row-settings').index();
            var index_pane = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index_pane + ') .kpt-pane-rows .kpt-pane-single-row').eq(index).css('line-height', parseFloat($(this).val()) + 'px');
        });
        // Letting Spacing
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-row_letter_spacing', function() {
           var index = $(this).closest('.single-row-settings').index();
            var index_pane = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index_pane + ') .kpt-pane-rows .kpt-pane-single-row').eq(index).css('letter-spacing', parseFloat($(this).val()) + 'px');
        });
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-row_padding', function() {
           var index = $(this).closest('.single-row-settings').index();
            var index_pane = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index_pane + ') .kpt-pane-rows .kpt-pane-single-row').eq(index).css('padding-top', parseFloat($(this).val()));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index_pane + ') .kpt-pane-rows .kpt-pane-single-row').eq(index).css('padding-bottom', parseFloat($(this).val()));
        });
        // Font Family and Weight
        $('.kpt-admin').on('change', '.pane-settings .kpt-row_font .kpt-layer-font', function() {
           var index = $(this).closest('.single-row-settings').index();
            var index_pane = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index_pane + ') .kpt-pane-rows .kpt-pane-single-row').eq(index).css('font-family', $(this).find(':selected').data('family'));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index_pane + ') .kpt-pane-rows .kpt-pane-single-row').eq(index).css('font-weight', parseFloat($(this).find(':selected').data('weight')));
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index_pane + ') .kpt-pane-rows .kpt-pane-single-row').eq(index).css('font-style', $(this).find(':selected').data('style'));
        });
        $('.kpt-admin').on('keyup mouseup', '.pane-settings .kpt-row_height', function() {
           var index = $(this).closest('.single-row-settings').index();
            var index_pane = $(this).closest('.kpt-pane-settings-list').index();
            $(this).closest('#kpt-panes').find('.kpt-table-editing-area .kpt-pane:eq(' + index_pane + ') .kpt-pane-rows .kpt-pane-single-row').eq(index).css('min-height', parseFloat($(this).val()));
        });

    	// Save or update the new Table in the database
        $('.kpt-admin .ksp-save-settings').click(function(e) {
            ksp_saveTable();
            e.preventDefault();
        });

        // Delete Table
        $('.kpt-admin .ksp-base .kpt-tables-list .ksp-delete-table').click(function() {
            var confirm = window.confirm(kpt_translations.table_delete_confirm);
            if(!confirm) {
                return;
            }
            
            kpt_deleteTable($(this));
        });
        // Duplicate table
        $('.kpt-admin .ksp-base').on('click', '.kpt-tables-list .ksp-duplicate-table', function() {
            kpt_duplicateTable($(this));
        });
        // Export table
        $('.kpt-admin .ksp-base').on('click', '.kpt-tables-list .ksp-export-table', function() {
            kpt_exportTable($(this));
        });

        $('.kpt-admin .ksp-base').on('click', '.kpt-import-template', function() {
            ksp_importtemplateTable($(this));
        });
        // Import table
        $('.kpt-admin .ksp-base').on('click', '.kpt-import-table', function() {
            $('#kpt-import-file').trigger('click');
        });
        $('.kpt-admin .ksp-base').on('change', '#kpt-import-file', function() {
            ksp_importTable();
        });

        // Sends an array with the new or current slider options
        function ksp_saveTable() {
            var overlay = $(document.getElementById('kt_ajax_overlay'));
            var content = $('.kpt-table #kpt-table-settings');
            var options = {
                id : parseInt($('.ksp-save-settings').data('id')),
                name : content.find('#ksp-title').val(),
                template : content.find('#kpt-template').val(),
                animation : content.find('#kpt-animation').val(),
                hover_effect : content.find('#kpt-hover').val(),
                text_align : content.find('#kpt-text_align').val(),
                enable_top_head_row : parseInt(content.find('#kpt-enable_top_row').is(':checked') ? 1 : 0),
                enable_price_row : parseInt(content.find('#kpt-enable_price_row').is(':checked') ? 1 : 0),
                enable_description_row : parseInt(content.find('#kpt-enable_description_row').is(':checked') ? 1 : 0),
                enable_footer_row : parseInt(content.find('#kpt-enable_footer_row').is(':checked') ? 1 : 0),
            };
            overlay.fadeIn();
            // Do the ajax call
            jQuery.ajax({
                type : 'POST',
                dataType : 'json',
                url : ajaxurl,
                data : {
                    // Is it saving or updating?
                    action: $('.kpt-table').hasClass('kpt-add-table') ? 'kpt_addTable' : 'kpt_editTable',
                    datas : options,
                },
                success: function(response) {
                    //alert('Save slider response: ' + response);
                    // If adding a new slider, response will be the generated id, else will be the number of rows modified
                    if(response !== false) {
                        // If is adding a slider, redirect
                        if($('.kpt-table').hasClass('kpt-add-table')) {
                            window.location.href = '?page=kadencepricingtable&view=tableedit&id=' + response;
                            return;
                        }
                        ksp_savePanes();
                    } else {
                       ksp_showError();
                    }
                },
                
                error: function(XMLHttpRequest, textStatus, errorThrown) { 
                    alert('Error saving slider');
                    alert("Status: " + textStatus);
                    alert("Error: " + errorThrown); 
                     ksp_showError();
                }
            });
        }
        // Sends an array with all the slides options
        function ksp_savePanes() {
            var panes = $('#kpt-panes .pane-settings .kpt-pane-settings-list');
            var i = 0;
            var final_options = {};
            
            final_options['options'] = new Array();         
            panes.each(function() {
                var pane = $(this);
                var content = $(this);
                var options = {
                    table_parent : parseInt($('.kpt-admin .ksp-save-settings').data('id')),                
                    position : i,
                    top_head_background : pane.find('.pane-top-settings .kpt-top_background').val(),
					top_head_color :  pane.find('.pane-top-settings .kpt-top_color').val(),
					top_head_font_size : parseInt(pane.find('.pane-top-settings .kpt-top_font_size').val()),
					top_head_letter_spacing : parseInt(pane.find('.pane-top-settings .kpt-top_letter_spacing').val()),
					top_head_line_height : parseInt(pane.find('.pane-top-settings .kpt-top_line_height').val()),
					top_head_font : pane.find('.pane-top-settings .kpt-top_font .kpt-layer-font').val(),
					top_head_padding : parseInt(pane.find('.pane-top-settings .kpt-top_padding').val()),
					top_head_height : parseInt(pane.find('.pane-top-settings .kpt-top_height').val()),
					top_head_html : pane.find('.pane-top-settings .kpt-top_html').val(),
					top_head_icon : null,
					top_head_image : pane.find('.pane-top-settings .kpt-top_image .kpt-image-upload-button').attr('data-src'),
					price_background : pane.find('.pane-price-settings .kpt-price_background').val(),
					price_color : pane.find('.pane-price-settings .kpt-price_color').val(),
					price_font_size : parseInt(pane.find('.pane-price-settings .kpt-price_font_size').val()),
					price_letter_spacing : parseInt(pane.find('.pane-price-settings .kpt-price_letter_spacing').val()),
					price_line_height : parseInt(pane.find('.pane-price-settings .kpt-price_line_height').val()),
					price_font : pane.find('.pane-price-settings .kpt-price_font .kpt-layer-font').val(),
					price_sub_color : pane.find('.pane-price-settings .kpt-price_sub_color').val(),
					price_sub_font_size : parseInt(pane.find('.pane-price-settings .kpt-price_sub_font_size').val()),
					price_sub_letter_spacing : parseInt(pane.find('.pane-price-settings .kpt-price_sub_letter_spacing').val()),
					price_sub_line_height : parseInt(pane.find('.pane-price-settings .kpt-price_sub_line_height').val()),
					price_sub_font : pane.find('.pane-price-settings .kpt-price_sub_font .kpt-layer-font').val(),
					price_height : parseInt(pane.find('.pane-price-settings .kpt-price_height').val()),
					price_padding : parseInt(pane.find('.pane-price-settings .kpt-price_padding').val()),
					price_html : pane.find('.pane-price-settings .kpt-price_html').val(),
					price_sub_html : pane.find('.pane-price-settings .kpt-price_sub_html').val(),
					description_background : pane.find('.pane-description-settings .kpt-description_background').val(),
					description_color : pane.find('.pane-description-settings .kpt-description_color').val(),
					description_font_size : parseInt(pane.find('.pane-description-settings .kpt-description_font_size').val()),
					description_letter_spacing : parseInt(pane.find('.pane-description-settings .kpt-description_letter_spacing').val()),
					description_line_height : parseInt(pane.find('.pane-description-settings .kpt-description_line_height').val()),
					description_font :  pane.find('.pane-description-settings .kpt-description_font .kpt-layer-font').val(),
					description_padding : parseInt(pane.find('.pane-description-settings .kpt-description_padding').val()),
					description_height : parseInt(pane.find('.pane-description-settings .kpt-description_height').val()),
					description_html : pane.find('.pane-description-settings .kpt-description_html').val(),
                    footer_background : pane.find('.pane-footer-settings .kpt-footer_background').val(),
                    footer_color : pane.find('.pane-footer-settings .kpt-footer_color').val(),
                    footer_color_hover : pane.find('.pane-footer-settings .kpt-footer_color_hover').val(),
                    footer_font_size :  parseInt(pane.find('.pane-footer-settings .kpt-footer_font_size').val()),
                    footer_letter_spacing :  parseInt(pane.find('.pane-footer-settings .kpt-footer_letter_spacing').val()),
                    footer_line_height :  parseInt(pane.find('.pane-footer-settings .kpt-footer_line_height').val()),
                    footer_btn_background : pane.find('.pane-footer-settings .kpt-footer_btn_background').val(),
                    footer_btn_background_hover : pane.find('.pane-footer-settings .kpt-footer_btn_background_hover').val(),
                    footer_btn_border_color : pane.find('.pane-footer-settings .kpt-footer_btn_border_color').val(),
                    footer_btn_border_color_hover : pane.find('.pane-footer-settings .kpt-footer_btn_border_color_hover').val(),
                    footer_btn_border_width :  parseInt(pane.find('.pane-footer-settings .kpt-footer_btn_border_width').val()),
                    footer_btn_border_radius :  parseInt(pane.find('.pane-footer-settings .kpt-footer_btn_border_radius').val()),
                    footer_btn_padding :  parseInt(pane.find('.pane-footer-settings .kpt-footer_btn_padding').val()),
                    footer_font : pane.find('.pane-footer-settings .kpt-footer_font .kpt-layer-font').val(),
                    footer_height :  parseInt(pane.find('.pane-footer-settings .kpt-footer_height').val()),
                    footer_link : pane.find('.pane-footer-settings .kpt-footer_btn_link').val(),
                    footer_link_new_tab : parseInt(pane.find('.pane-footer-settings .kpt-footer_btn_link_new_tab').is(':checked') ? 1 : 0),
                    footer_html : pane.find('.pane-footer-settings .kpt-footer_html').val(),
                    featured_background: pane.find('.pane-featured-settings .kpt-featured_background').val(),
					featured_color: pane.find('.pane-featured-settings .kpt-featured_color').val(),
					featured : pane.find('.pane-featured-settings .kpt-feature-column').val(),
					featured_text: pane.find('.pane-featured-settings .kpt-featured_text').val(),
					featured_font_size: parseInt(pane.find('.pane-featured-settings .kpt-featured_font_size').val()),
					featured_letter_spacing : parseInt(pane.find('.pane-featured-settings .kpt-featured_letter_spacing').val()),
					featured_font: pane.find('.pane-featured-settings .kpt-featured_font .kpt-layer-font').val(),
					featured_line_height:  parseInt(pane.find('.pane-featured-settings .kpt-featured_line_height').val()),
					featured_border_color :pane.find('.pane-featured-settings .kpt-featured_border_color').val(),
					featured_border_width : parseInt(pane.find('.pane-featured-settings .kpt-featured_border_width').val()),
					featured_border_radius : parseInt(pane.find('.pane-featured-settings .kpt-featured_border_radius').val()),
					featured_size : parseInt(pane.find('.pane-featured-settings .kpt-featured_size').val()),
                };
                
                final_options['options'][i] = options;
                
                i++;
            });
            
            final_options['table_parent'] = parseInt($('.kpt-admin .ksp-save-settings').data('id')),
            
            // Do the ajax call
            jQuery.ajax({
                type : 'POST',
                dataType : 'json',
                url : ajaxurl,
                data : {
                    action: 'kpt_editPanes',
                    datas : final_options,
                },
                success: function(response) {
                    //alert('Save slides response: ' + response);
                    if(response !== false) {
                        kpt_save_single_rows();
                       // ksp_showSuccess();
                    }
                    else {
                        ksp_showError();
                    }
                },
                
                error: function(XMLHttpRequest, textStatus, errorThrown) { 
                    alert('Error saving slides');
                    alert("Status: " + textStatus);
                    alert("Error: " + errorThrown); 
                    ksp_showError();
                }
            });
        }
        
        // Sends an array with all the layers options of each slide
        function kpt_save_single_rows() {
        	var panes = $('#kpt-panes .pane-settings .kpt-pane-settings-list');
            var i = 0, j = 0;
            var final_options = {};
            
            final_options['options'] = new Array();
            panes.each(function() {
                var pane = $(this);
                var rows = pane.find('.pane-row-settings .single-row-settings');
                
                rows.each(function() {
                    var row = $(this);                  
                    var options = {
                        table_parent : parseInt($('.kpt-admin .ksp-save-settings').data('id')),  
                        pane_parent : i,   
                        position : row.index(),                     
                        inner_html : row.find('.kpt-row_html').val(),
                        icon : '',
                        image : '',
                        height : parseInt(row.find('.kpt-row_height').val()),
                        padding : parseInt(row.find('.kpt-row_padding').val()),
                        color : row.find('.kpt-row_color').val(),
                        background : row.find('.kpt-row_background').val(),
                        padding : row.find('.kpt-row_padding').val(),
                        font_size : parseInt(row.find('.kpt-row_font_size').val()),
                        line_height : parseInt(row.find('.kpt-row_line_height').val()),
                        letter_spacing : parseInt(row.find('.kpt-row_letter_spacing').val()),
                        font : row.find('.kpt-row_font .kpt-layer-font').val(),
                       
                    };
                    
                    final_options['options'][j] = options;
                    
                    j++;
                });
                
                i++;
            });
            
            // Proceed?
            final_options['rows'] = 1;
            if(final_options['options'].length == 0) {
                final_options['rows'] = 0;
            }
            
            final_options['table_parent'] = parseInt($('.kpt-admin .ksp-save-settings').data('id'));
            
            final_options['options'] = JSON.stringify(final_options['options']);

            // Do the ajax call
            jQuery.ajax({
                type : 'POST',
                dataType : 'json',
                url : ajaxurl,
                data : {
                    action: 'kpt_editTablerows',
                    datas : final_options,
                },
                success: function(response) {
                    if(response !== false) {
                        $('.kpt-admin').trigger( "savedTable" );
                        ksp_showSuccess();
                    } else {
                        ksp_showError();
                    }
                },
                
                error: function(XMLHttpRequest, textStatus, errorThrown) { 
                    alert('Error saving layers');
                    console.log(XMLHttpRequest.responseText);
                    ksp_showError();
                }
            });
        }
        function kpt_deleteTable(content) {
            // Get options
            var options = {
                id : parseInt(content.data('delete')),
            };
            
            // Do the ajax call
            jQuery.ajax({
                type : 'POST',
                dataType : 'json',
                url : ajaxurl,
                data : {
                    action: 'kpt_deleteTable',
                    datas : options,
                },
                success: function(response) {
                    //alert('Delete slider response: ' + response);
                    if(response !== false) {
                        content.parent().parent().remove();
                        ksp_showSuccess();
                    }
                    else {
                        ksp_showError();
                    }
                },
                
                error: function(XMLHttpRequest, textStatus, errorThrown) { 
                    alert('Error deleting slider');
                    alert("Status: " + textStatus);
                    alert("Error: " + errorThrown); 
                    ksp_showError();
                },
            });
        }
        function kpt_duplicateTable(content) {
            var overlay = $(document.getElementById('kt_ajax_overlay'));
            var options = {
                id : parseInt(content.data('duplicate')),
            };
            overlay.fadeIn();
            
            // Do the ajax call
            jQuery.ajax({
                type : 'POST',
                dataType : 'json',
                url : ajaxurl,
                data : {
                    action: 'kpt_duplicateTable',
                    datas : options,
                },
                success: function(response) {
                    //console.log(response);
                    if(response['response'] !== false) {
                        var cloned_table = content.parent().parent().clone().appendTo(content.parent().parent().parent());
                        cloned_table.find('.ksp_column_02').html(response['cloned_table_id']);
                        cloned_table.find('.ksp_column_03 a').html(response['cloned_table_name']);
                        cloned_table.find('.ksp_column_03 a').attr('href', '?page=kadencepricingtable&view=tableedit&id=' + response['cloned_table_id']);
                        cloned_table.find('.ksp_column_04').html('[kadence_pricing_table id="' + response['cloned_table_id'] + '"]');
                        cloned_table.find('.ksp-edit-table').attr('href', '?page=kadencepricingtable&view=tableedit&id=' + response['cloned_table_id']);
                        cloned_table.find('.ksp-duplicate-table').data('duplicate', response['cloned_table_id']);
                        cloned_table.find('.ksp-delete-table').data('delete', response['cloned_table_id']);
                        cloned_table.find('.ksp-export-table').data('export', response['cloned_table_id']);
                        ksp_showSuccess();
                    } else {
                        ksp_showError();
                    }
                },
                
                error: function(XMLHttpRequest, textStatus, errorThrown) { 
                    alert('Error duplicating slider');
                    console.log(XMLHttpRequest.responseText);
                    ksp_showError();
                },
            });
        }

        function kpt_exportTable(content) {
            var overlay = $(document.getElementById('kt_ajax_overlay'));
            var options = {
                id : parseInt(content.data('export')),
            };
            overlay.fadeIn();
            
            // Do the ajax call
            jQuery.ajax({
                type : 'POST',
                dataType : 'json',
                url : ajaxurl,
                data : {
                    action: 'kpt_exportTable',
                    datas : options,
                },
                success: function(response) {
                    if(response['response'] !== false) {                        
                        window.location.href = response['url'];
                        ksp_showSuccess();
                    }
                    else {
                        ksp_showError();
                    }
                },
                
                error: function(XMLHttpRequest, textStatus, errorThrown) { 
                    alert('Error while exporting the slider');
                    console.log(XMLHttpRequest.responseText);
                    ksp_showError();
                },
            });
        }
        function ksp_importTable() {
            var overlay = $(document.getElementById('kt_ajax_overlay'));
            var file = $('#kpt-import-file')[0].files[0];
            
            if(! file) {
                return;
            }
            
            $('#kpt-import-file').val('');
            
            // Form data (for file uploads)
            var fd = new FormData();
            fd.append('file', file);
            fd.append('action', 'kpt_importTable');  

            overlay.fadeIn();
            // Do the ajax call
            jQuery.ajax({
                type : 'POST',
                url : ajaxurl,
                contentType: false,
                processData : false,
                data : fd,
                success: function(response) {
                    response = JSON.parse(response);
                    //console.log(response);
                    if(response['response'] !== false) {
                        var content = $('.ksp-sliders-list .ksp-duplicate-slider:eq(0)');
                        if(content.length > 0) {
                            var imported_table = content.parent().parent().clone().appendTo(content.parent().parent().parent());
                            imported_table.find('.ksp_column_02').html(response['imported_table_id']);
                            imported_table.find('.ksp_column_03 a').html(response['imported_table_name']);
                            imported_table.find('.ksp_column_03 a').attr('href', '?page=kadencepricingtable&view=tableedit&id=' + response['imported_table_id']);
                            imported_table.find('.ksp_column_04').html('[kadence_pricing_table id="' + response['imported_table_id'] + '"]');
                            imported_table.find('.ksp-edit-table').attr('href', '?page=kadencepricingtable&view=tableedit&id=' + response['imported_table_id']);
                            imported_table.find('.ksp-duplicate-table').data('duplicate', response['imported_table_id']);
                            imported_table.find('.ksp-delete-table').data('delete', response['imported_table_id']);
                            imported_table.find('.ksp-delete-table').data('export', response['imported_table_id']);
                        } else {
                            location.reload();
                        }
                        
                        ksp_showSuccess();
                    }
                    else {
                        ksp_showError();
                    }
                },
                
                error: function(XMLHttpRequest, textStatus, errorThrown) { 
                    alert('Error while importing the slider');
                    console.log(XMLHttpRequest.responseText);
                    ksp_showError();
                },
            });
        }
		function ksp_importtemplateTable(content) {
            var overlay = $(document.getElementById('kt_ajax_overlay'));
            var options = {
                file : content.data('import'),
            }; 

            overlay.fadeIn();
            // Do the ajax call
            jQuery.ajax({
                type : 'POST',
                dataType : 'json',
                url : ajaxurl,
                data : {
                    action: 'kpt_importTemplateTable',
                    datas : options,
                },
                success: function(response) {
                    if(response['response'] !== false) {
                        window.location.href = kpt_translations.kpt_admin+'&view=tableedit&id='+ response['imported_table_id'];
                    }
                    else {
                        ksp_showError();
                    }
                },
                
                error: function(XMLHttpRequest, textStatus, errorThrown) { 
                    alert('Error while importing the slider');
                    console.log(XMLHttpRequest.responseText);
                    ksp_showError();
                },
            });
        }
    });
})(jQuery);

