<?php
$templates = array(
		'flat' => array(__('Flat no margin', 'kadence-pricing-table'), true),
		'flatmargin' => array(__('Flat with margin', 'kadence-pricing-table'), false),
		//'outline' => array(__('Outline', 'kadence-pricing-table'), false),
	);
$animations = array(
		'none' => array(__('None', 'kadence-pricing-table'), true),
		'fadein' => array(__('Fade In Together', 'kadence-pricing-table'), true),
		'fadein_time' => array(__('Fade In one at a time', 'kadence-pricing-table'), false),
		'fadeleft' => array(__('Fade in left', 'kadence-pricing-table'), false),
		'fadeleftright' => array(__('Fade in left and right columns', 'kadence-pricing-table'), false),
		'fadeinup_time' => array(__('Fade in up one at a time', 'kadence-pricing-table'), false),
	);
$hover = array(
		'none' => array(__('None', 'kadence-pricing-table'), true),
		'grow' => array(__('Grow Column', 'kadence-pricing-table'), false),
		'boxshadow' => array(__('Box Shadow', 'kadence-pricing-table'), false),
	);
$align = array(
		'left' => array(__('Left', 'kadence-pricing-table'), true),
		'center' => array(__('Center', 'kadence-pricing-table'), false),
		'right' => array(__('Right', 'kadence-pricing-table'), false),
	);
?>
<section id="kpt-table-settings" class="ksp-tab-content" style="display:block;">
	<div class="ksp-settings-table ksp-table">
		<div class="ksp-settings-table-head ksp-tab-title">
				<h3><?php _e('Table Settings', 'kadence-pricing-table'); ?></h3>
		</div>
		<div class="ksp-row">
			<div class="ksp-column ksp-full">
				<strong><?php _e('Pricing Table Name:', 'kadence-pricing-table'); ?></strong>
				<input type="text" id="ksp-title" placeholder="<?php _e('New Table', 'kadence-pricing-table'); ?>" value="<?php if($edit){ echo esc_attr($table->name);} ?>" />
			</div>
		</div>
		<div class="ksp-row">
			<div class="ksp-column ksp-odd">
				<strong><?php _e('ID:', 'kadence-pricing-table'); ?></strong>
				<span id="ksp-id-output"><?php if($edit) { echo $table->id; } ?></span>
			</div>
			<div class="ksp-column ksp-even">
				<strong><?php _e('Shortcode:', 'kadence-pricing-table'); ?></strong>	
				<span id="ksp-slider-shortcode"><?php if($edit) { echo '[kadence_pricing_table id="'.$table->id.'"]';}?></span>
			</div>
		</div>
		<div class="ksp-row">
			<div class="ksp-column kpt-col-4 ksp-odd">
				<div class="ksp-label">
					<?php _e('Skin Style', 'kadence-pricing-table'); ?>
					</div>
				<div class="ksp-content">
					<select id="kpt-template" class="kpt-template">
					<?php
						foreach($templates as $key => $value) {
							echo '<option value="' . esc_attr($key) . '"';
							if((!$edit && $key == "flat") || ($edit && $table->template == $key)) {
								echo ' selected';
							}
							echo '>' . esc_html($value[0]) . '</option>';
						}
					?>
					</select>
				</div>
			</div>
			<div class="ksp-column kpt-col-4 ksp-even">
				<div class="ksp-label">
					<?php _e('Load Animation', 'kadence-pricing-table'); ?>
					</div>
				<div class="ksp-content">
					<select id="kpt-animation" class="kpt-animation">
					<?php
						foreach($animations as $key => $value) {
							echo '<option value="' . esc_attr($key) . '"';
							if((!$edit && $key == "none") || ($edit && $table->animation == $key)) {
								echo ' selected';
							}
							echo '>' . esc_html($value[0]) . '</option>';
						}
					?>
					</select>
				</div>
			</div>
			<div class="ksp-column kpt-col-4 ksp-odd">
				<div class="ksp-label">
					<?php _e('Hover Effect', 'kadence-pricing-table'); ?>
					</div>
				<div class="ksp-content">
					<select id="kpt-hover" class="kpt-hover">
					<?php
						foreach($hover as $key => $value) {
							echo '<option value="' . esc_attr($key) . '"';
							if((!$edit && $key == "none") || ($edit && $table->hover_effect == $key)) {
								echo ' selected';
							}
							echo '>' . esc_html($value[0]) . '</option>';
						}
					?>
					</select>
				</div>
			</div>
			<div class="ksp-column kpt-col-4 ksp-even">
				<div class="ksp-label">
					<?php _e('Text Align', 'kadence-pricing-table'); ?>
					</div>
				<div class="ksp-content">
					<select id="kpt-text_align" class="kpt-text_align">
					<?php
						foreach($align as $key => $value) {
							echo '<option value="' . esc_attr($key) . '"';
							if((!$edit && $key == "center") || ($edit && $table->text_align == $key)) {
								echo ' selected';
							}
							echo '>' . esc_html($value[0]) . '</option>';
						}
					?>
					</select>
				</div>
			</div>
		</div>
		<div class="ksp-row">
			<div class="ksp-column kpt-col-4 ksp-odd">
				<div class="ksp-label">
					<?php _e('Enable Top Head Row', 'kadence-pricing-table'); ?>
					</div>
				<div class="ksp-content">
					<div class="onoffswitch">
					    <input type="checkbox" name="onoffswitch" class="onoffswitch-checkbox" id="kpt-enable_top_row" <?php if(!$edit || $edit && $table->enable_top_head_row == 1) {
						echo 'checked';
					}?> >
					    <label class="onoffswitch-label" for="kpt-enable_top_row">
					        <span class="onoffswitch-inner"></span>
					        <span class="onoffswitch-switch"></span>
					    </label>
					</div>
				</div>
			</div>
			<div class="ksp-column kpt-col-4 ksp-even">
				<div class="ksp-label">
					<?php _e('Enable Price Row', 'kadence-pricing-table'); ?>
					</div>
				<div class="ksp-content">
					<div class="onoffswitch">
					    <input type="checkbox" name="onoffswitch" class="onoffswitch-checkbox" id="kpt-enable_price_row" <?php if(!$edit || $edit && $table->enable_price_row == 1) {
						echo 'checked';
					}?> >
					    <label class="onoffswitch-label" for="kpt-enable_price_row">
					        <span class="onoffswitch-inner"></span>
					        <span class="onoffswitch-switch"></span>
					    </label>
					</div>
				</div>
			</div>
			<div class="ksp-column kpt-col-4 ksp-odd">
				<div class="ksp-label">
					<?php _e('Enable Description Row', 'kadence-pricing-table'); ?>
					</div>
				<div class="ksp-content">
					<div class="onoffswitch">
					    <input type="checkbox" name="onoffswitch" class="onoffswitch-checkbox" id="kpt-enable_description_row" <?php if(!$edit || $edit && $table->enable_description_row == 1) {
						echo 'checked';
					}?> >
					    <label class="onoffswitch-label" for="kpt-enable_description_row">
					        <span class="onoffswitch-inner"></span>
					        <span class="onoffswitch-switch"></span>
					    </label>
					</div>
				</div>
			</div>
			<div class="ksp-column kpt-col-4 ksp-even">
				<div class="ksp-label">
					<?php _e('Enable Footer Row', 'kadence-pricing-table'); ?>
					</div>
				<div class="ksp-content">
					<div class="onoffswitch">
					    <input type="checkbox" name="onoffswitch" class="onoffswitch-checkbox" id="kpt-enable_footer_row" <?php if(!$edit || $edit && $table->enable_footer_row == 1) {
						echo 'checked';
					}?> >
					    <label class="onoffswitch-label" for="kpt-enable_footer_row">
					        <span class="onoffswitch-inner"></span>
					        <span class="onoffswitch-switch"></span>
					    </label>
					</div>
				</div>
			</div>
		</div>
</div>
</section>