/*
 * jQuery.appear
 * https://github.com/bas2k/jquery.appear/
 * http://code.google.com/p/jquery-appear/
 * http://bas2k.ru/
 *
 * Copyright (c) 2009 Michael Hixson
 * Copyright (c) 2012-2014 Alexander Brovikov
 * Licensed under the MIT license (http://www.opensource.org/licenses/mit-license.php)
 */
(function($) {
    $.fn.appear_kpt = function(fn, options) {

        var settings = $.extend({

            //arbitrary data to pass to fn
            data: undefined,

            //call fn only on the first appear?
            one: true,

            // X & Y accuracy
            accX: 0,
            accY: 0

        }, options);

        return this.each(function() {

            var t = $(this);

            //whether the element is currently visible
            t.appeared = false;

            if (!fn) {

                //trigger the custom event
                t.trigger('appear', settings.data);
                return;
            }

            var w = $(window);

            //fires the appear event when appropriate
            var check = function() {

                //is the element hidden?
                if (!t.is(':visible')) {

                    //it became hidden
                    t.appeared = false;
                    return;
                }

                //is the element inside the visible window?
                var a = w.scrollLeft();
                var b = w.scrollTop();
                var o = t.offset();
                var x = o.left;
                var y = o.top;

                var ax = settings.accX;
                var ay = settings.accY;
                var th = t.height();
                var wh = w.height();
                var tw = t.width();
                var ww = w.width();

                if (y + th + ay >= b &&
                    y <= b + wh + ay &&
                    x + tw + ax >= a &&
                    x <= a + ww + ax) {

                    //trigger the custom event
                    if (!t.appeared) t.trigger('appear', settings.data);

                } else {

                    //it scrolled out of view
                    t.appeared = false;
                }
            };

            //create a modified fn with some additional logic
            var modifiedFn = function() {

                //mark the element as visible
                t.appeared = true;

                //is this supposed to happen only once?
                if (settings.one) {

                    //remove the check
                    w.unbind('scroll', check);
                    var i = $.inArray(check, $.fn.appear_kpt.checks);
                    if (i >= 0) $.fn.appear_kpt.checks.splice(i, 1);
                }

                //trigger the original fn
                fn.apply(this, arguments);
            };

            //bind the modified fn to the element
            if (settings.one) t.one('appear', settings.data, modifiedFn);
            else t.bind('appear', settings.data, modifiedFn);

            //check whenever the window scrolls
            w.scroll(check);

            //check whenever the dom changes
            $.fn.appear_kpt.checks.push(check);

            //check now
            (check)();
        });
    };

    //keep a queue of appearance checks
    $.extend($.fn.appear_kpt, {

        checks: [],
        timeout: null,

        //process the queue
        checkAll: function() {
            var length = $.fn.appear_kpt.checks.length;
            if (length > 0) while (length--) ($.fn.appear_kpt.checks[length])();
        },

        //check the queue asynchronously
        run: function() {
            if ($.fn.appear_kpt.timeout) clearTimeout($.fn.appear_kpt.timeout);
            $.fn.appear_kpt.timeout = setTimeout($.fn.appear_kpt.checkAll, 20);
        }
    });

    //run checks when these methods are called
    $.each(['append', 'prepend', 'after', 'before', 'attr',
        'removeAttr', 'addClass', 'removeClass', 'toggleClass',
        'remove', 'css', 'show', 'hide'], function(i, n) {
        var old = $.fn[n];
        if (old) {
            $.fn[n] = function() {
                var r = old.apply(this, arguments);
                $.fn.appear_kpt.run();
                return r;
            }
        }
    });

})(jQuery);

jQuery(document).ready(function ($) {

    $( ".kpt-table-area .kpt-footer-btn" ).each(function() {
            $(this).mouseover(function() {
                $(this).css('color', $(this).data('hcolor'));
                $(this).css('border-color', $(this).data('hborder-color'));
                $(this).css('background', $(this).data('hbackground-color'));
            });
            $(this).mouseout(function() {
                $(this).css('color', $(this).data('color'));
                $(this).css('border-color', $(this).data('border-color'));
                $(this).css('background', $(this).data('background-color'));
            });
        });

    if($(window).width() > 790) {
           //fadein
        $('.kpt-table-area.table-animate-fadeinup_time').each(function() {
            $(this).appear_kpt(function() {
            	var child =  $(this).find('li.kpt-pane');
            	child.each(function(i){
						$(this).delay(i*300).animate({'opacity':1, 'top' : 0},500);				
					});
			});
        });
        $('.kpt-table-area.table-animate-fadeleftright').each(function() {
            $(this).appear_kpt(function() {
            	var child =  $(this).find('li.kpt-pane:not(:last-child):not(:first-child)');
            	var lastchild =  $(this).find('li.kpt-pane:last-child');
            	var firstchild =  $(this).find('li.kpt-pane:first-child');
            	firstchild.each(function(i){
						$(this).animate({'opacity':1, 'left' : 0},1000);
				});
            	lastchild.each(function(i){
						$(this).animate({'opacity':1, 'right' : 0},1000);
				});
            	child.each(function(i){
						$(this).animate({'opacity':1, 'top' : 0},1000);
				});
			});
        });
        $('.kpt-table-area.table-animate-fadeleft').each(function() {
            $(this).appear_kpt(function() {
            	var child =  $(this).find('li.kpt-pane');
            	child.each(function(i){
						$(this).delay(i*300).animate({'opacity':1, 'left' : 0},500);
				});
			});
        });
        $('.kpt-table-area.table-animate-fadein_time').each(function() {
            $(this).appear_kpt(function() {
            	var child =  $(this).find('li.kpt-pane');
            	child.each(function(i){
						$(this).delay(i*300).animate({'opacity':1},500);
				});
			});
        });
        $('.kpt-table-area.table-animate-fadein').each(function() {
            $(this).appear_kpt(function() {
            	$(this).animate({'opacity' : 1 },1000,'swing');
            });
        });
    } else {
    	 $('.kpt-table-area.table-animate-fadeinup_time').each(function() {
            	var child =  $(this).find('li.kpt-pane');
            	child.each(function(i){
						$(this).animate({'opacity':1, 'top' : 0},1000);
				});
        });
    	 $('.kpt-table-area.table-animate-fadeleftright').each(function() {
            	var child =  $(this).find('li.kpt-pane:not(:last-child):not(:first-child)');
            	var lastchild =  $(this).find('li.kpt-pane:last-child');
            	var firstchild =  $(this).find('li.kpt-pane:first-child');
            	firstchild.each(function(i){
						$(this).animate({'opacity':1, 'left' : 0},1000);
				});
            	lastchild.each(function(i){
						$(this).animate({'opacity':1, 'right' : 0},1000);
				});
            	child.each(function(i){
						$(this).animate({'opacity':1, 'top' : 0},1000);
				});
        });
    	$('.kpt-table-area.table-animate-fadeleft').each(function() {
    		var child =  $(this).find('li.kpt-pane');
            	child.each(function(i){
    				$(this).animate({'opacity' : 1, 'left' : 0});
    			});
    	});
    	$('.kpt-table-area.table-animate-fadein_time').each(function() {
    		var child =  $(this).find('li.kpt-pane');
            	child.each(function(i){
    				$(this).animate({'opacity' : 1});
    			});
    	});
    	$('.kpt-table-area.table-animate-fadein').each(function() {
    		$(this).animate({'opacity' : 1});
    	});
    }
});