<?php

/*
Plugin Name: Kadence Pricing Table
Description: Responsive Price Table plugin.
Version: 1.0.5
Author: Kadence Themes
Author URI: http://kadencethemes.com/
License: GPLv2 or later
*/
function kadence_pricing_table_activation() {
}
register_activation_hook(__FILE__, 'kadence_pricing_table_activation');

function kadence_pricing_table_deactivation() {
}
register_deactivation_hook(__FILE__, 'kadence_pricing_table_deactivation');

// Define constants
define('KADENCE_PT_PATH', realpath(plugin_dir_path(__FILE__)) . DIRECTORY_SEPARATOR );
define('KADENCE_PT_URL', plugin_dir_url(__FILE__) );
define('KADENCE_PT_VERSION', '1.0.5' );
define('KADENCE_PT_DEBUG', false);


// Frontoutput class
require_once( KADENCE_PT_PATH . '/kadence-pricing-table-frontend.php');
KadencePricingTable_Output::addShortcode();

// Frontend Scripts
function kadence_pricing_table_scripts() {
  wp_enqueue_style('kadence_pricing_table_css', KADENCE_PT_URL . 'css/kpt.css', false, KADENCE_PT_VERSION);
  wp_enqueue_script('kadence_pricing_tabl_js', KADENCE_PT_URL . 'js/min/kpt-min.js', array('jquery'), KADENCE_PT_VERSION, true);
}
add_action('wp_enqueue_scripts', 'kadence_pricing_table_scripts', 100);
add_action( 'wp_enqueue_scripts', 'kadence_pricing_table_remove_scripts', 160 );
function kadence_pricing_table_remove_scripts(){
  	global $kadence_pricing_table;
  	if(isset($kadence_pricing_table['kpt_load_fonts']) && $kadence_pricing_table['kpt_load_fonts'] == 0) {
   		wp_dequeue_style('redux-google-fonts-kadence_pricing_table');
  	}
}
function ktp_theme_is_kadence() {
	if(class_exists('kt_api_manager')) {
		return true;
	}
	return false;
}


// Admin functions
require_once( KADENCE_PT_PATH . '/admin/database.php');
require_once( KADENCE_PT_PATH . '/admin/typography/typography.php');
require_once( KADENCE_PT_PATH . '/admin/admin-manage.php');


// Plugin Updates
add_action( "after_setup_theme", 'kt_pricing_table_updating', 1);
function kt_pricing_table_updating() {
    require_once('wp-updates-plugin.php');
    if ( ktp_theme_is_kadence() ) {
        $the_theme = wp_get_theme();
        $activated = false;
        if( $the_theme->get( 'Name' ) == 'Pinnacle Premium' || $the_theme->get( 'Template') == 'pinnacle_premium' ) {
            if ( get_option( 'kt_api_manager_pinnacle_premium_activated' ) == 'Activated' ) {
                $activated = true;
            }
        } else if( $the_theme->get( 'Name' ) == 'Ascend - Premium' || $the_theme->get( 'Template') == 'ascend_premium' ) {
            if ( get_option( 'kt_api_manager_ascend_premium_activated' ) == 'Activated' ) {
                $activated = true;
            }
        } else if(get_option( 'kt_api_manager_virtue_premium_activated' ) == 'Activated' ) {
            $activated = true;
        }
        if( $activated ) {
            $kad_pricing_table_updater = new PluginUpdateChecker_2_0 ('https://kernl.us/api/v1/updates/59273c950dcaf31c5fa835ee/',__FILE__, 'kadence-pricing-table', 1);
        }
    } else {
        require_once( KADENCE_PT_PATH . '/admin/kt_activation/kt-api.php');
        if ( get_option( 'kt_api_manager_kadence_pricing_table_activated' ) == 'Activated' ) {
            $kad_pricing_table_updater = new PluginUpdateChecker_2_0 ('https://kernl.us/api/v1/updates/59273c950dcaf31c5fa835ee/',__FILE__, 'kadence-pricing-table', 1);
        }
    }
}

/* text-domain */
function kpt_textdomain() {
  	load_plugin_textdomain( 'kadence-pricing-table', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' ); 
}
add_action( 'plugins_loaded', 'kpt_textdomain' );