<?php 
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

function pinnacle_ele_init_editor() {
	add_action( 'elementor/editor/before_enqueue_scripts', 'pinnacle_add_widget_support_elementor' );
}
function pinnacle_add_widget_support_elementor() {
	wp_enqueue_style('pinnacle_admin_styles', get_template_directory_uri() . '/assets/css/pinnacle_admin_styles.css', false, PINNACLE_VERSION);
	add_action( 'wp_print_footer_scripts','pinnacle_shortcode_content' );
	wp_enqueue_script('pinnacle_elementor_admin_scripts', get_template_directory_uri() . '/assets/js/pinnacle_elementor_admin_scripts.js', array( 'wp-color-picker', 'jquery' ) );
}
function pinnacle_elementor_fontend_support_scripts() {
	$elementor_instance = Elementor\Plugin::instance();
	if ( $elementor_instance->preview->is_preview_mode() ) {
		wp_enqueue_script( 'pinacle_elementor_preview' , get_template_directory_uri() . '/assets/js/pinnacle_elementor_preview.js', array( 'jquery', 'pinnacle_main' ), PINNACLE_VERSION, true);
	}
}
function pinnacle_elementor_init() {
	add_action( 'admin_action_elementor', 'pinnacle_ele_init_editor', 6 );
	add_action( 'admin_action_elementor', 'pinnacle_woo_archive_hooks_re_remove', 9 );
	add_action( 'elementor/frontend/after_enqueue_scripts', 'pinnacle_elementor_fontend_support_scripts' );
}
function pinnacle_woo_archive_hooks_re_remove() {
    remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );

	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
	remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );

	remove_action( 'woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_title', 10 );

	remove_action( 'woocommerce_single_variation', 'woocommerce_single_variation', 10 );
    remove_action( 'woocommerce_single_variation', 'woocommerce_single_variation_add_to_cart_button', 20 );

    remove_action( 'woocommerce_before_subcategory_title', 'woocommerce_subcategory_thumbnail', 10 );
    remove_action( 'woocommerce_before_subcategory', 'woocommerce_template_loop_category_link_open', 10 );
	remove_action( 'woocommerce_after_subcategory', 'woocommerce_template_loop_category_link_close', 10 );
}