<?php

/**
 * Page Hooks
 */

add_action( 'pinnacle_header', 'pinnacle_header_markup', 10 );
function pinnacle_header_markup() {
	global $pinnacle;
	$header_style = ( isset( $pinnacle['header_style'] ) ? $pinnacle['header_style'] : 'default' );
	if ( $header_style == 'center' ) {
		get_template_part('templates/header-center');
	} else {
		get_template_part('templates/header');
	}
}

add_action( 'pinnacle_footer', 'pinnacle_footer_markup', 10 );
function pinnacle_footer_markup() {
	get_template_part( 'templates/footer' );
}


add_action('kadence_page_footer', 'pinnacle_page_comments');
function pinnacle_page_comments() {
 global $pinnacle;
 if(isset($pinnacle['page_comments']) && $pinnacle['page_comments'] == 1) {
  comments_template('/templates/comments.php');
 }
}

// Footer

function kt_sitewide_shortcode_output() {
  global $pinnacle;

  if(isset($pinnacle['sitewide_footer_shortcode_input']) && !empty($pinnacle['sitewide_footer_shortcode_input'])) {
    echo '<div class="clearfix kt_footer_sitewide_shortcode">';
    echo do_shortcode($pinnacle['sitewide_footer_shortcode_input']);
    echo '</div>';
  }
}
add_action('kt_before_footer', 'kt_sitewide_shortcode_output', 10 );

function kt_sitewide_calltoaction_output() {

  global $pinnacle;

  if(isset($pinnacle['sitewide_calltoaction']) && $pinnacle['sitewide_calltoaction'] == 1) { 
    get_template_part('templates/sitewide', 'action'); 
  }
}
add_action('kt_before_footer', 'kt_sitewide_calltoaction_output', 20 );

function pinnacle_iso_filter($tax, $termtypes) {
	global $pinnacle;
	echo '<div id="options" class="kt-filter-options clearfix">';	
		if(!empty($pinnacle['filter_all_text'])) {
			$alltext = $pinnacle['filter_all_text'];
		} else {
			$alltext = __('All', 'pinnacle');
		}
		if(!empty($pinnacle['shop_filter_text'])) {
			$filter_text = $pinnacle['shop_filter_text'];
		} else {
			$filter_text = __('Filter Products', 'pinnacle');
		}
		$categories = get_terms($tax, $termtypes);
		$count 		= count($categories);
			echo '<a class="filter-trigger headerfont" data-toggle="collapse" data-target=".filter-collapse"><i class="icon-tags"></i> '.esc_html($filter_text).'</a>';
			echo '<ul id="filters" class="clearfix filter-set option-set filter-collapse">';
				echo '<li class="postclass"><a href="#" data-filter="*" title="'.esc_attr($alltext).'" class="selected"><h5>'.esc_html($alltext).'</h5><div class="arrow-up"></div></a></li>';
				if ( $count > 0 ){
					foreach ($categories as $category){ 
						$term_slug = strtolower($category->slug);
						echo '<li class="postclass kt-data-filter-'.esc_attr($term_slug).'"><a href="#" data-filter=".'.esc_attr($term_slug).'"><h5>'.esc_html($category->name).'</h5><div class="arrow-up"></div></a></li>';
					}
			 	}
			echo "</ul>"; 
	echo '</div>';
}